/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.skeleton;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.EmptyIterator;
import org.spoofax.terms.util.NotImplementedException;
import org.spoofax.terms.util.TermUtils;

public class SkeletonStrategoInt
extends StrategoTerm
implements IStrategoInt {
    private static final long serialVersionUID = 2915870332171452430L;
    private final BigInteger value;

    public SkeletonStrategoInt(long value, @Nullable IStrategoList annotations) {
        super(annotations);
        this.value = BigInteger.valueOf(value);
    }

    public SkeletonStrategoInt(int value) {
        this(value, null);
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return Collections.emptyList();
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY_TERM_ARRAY;
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public TermType getType() {
        return TermType.INT;
    }

    @Override
    public boolean isUniqueValueTerm() {
        return false;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        if (!TermUtils.isInt(second)) {
            return false;
        }
        if (this.intValue() != ((IStrategoInt)second).intValue()) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        throw new NotImplementedException();
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(Integer.toString(this.intValue()));
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        return 449 * this.intValue() ^ 0x1EA1;
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EmptyIterator<IStrategoTerm>();
    }
}

