/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.skeleton;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.util.ArrayIterator;
import org.spoofax.terms.util.NotImplementedException;
import org.spoofax.terms.util.TermUtils;

public abstract class SkeletonStrategoAppl
extends StrategoTerm
implements IStrategoAppl {
    private static final long serialVersionUID = -2522680523775044390L;

    public SkeletonStrategoAppl(@Nullable IStrategoList annotations) {
        super(annotations);
    }

    @Deprecated
    public final IStrategoTerm[] getArguments() {
        throw new NotImplementedException();
    }

    @Override
    public final String getName() {
        return this.getConstructor().getName();
    }

    @Override
    public final int getSubtermCount() {
        return this.getConstructor().getArity();
    }

    @Override
    @Deprecated
    public final int getTermType() {
        return this.getType().getValue();
    }

    @Override
    public final TermType getType() {
        return TermType.APPL;
    }

    @Override
    protected final boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        IStrategoList annotations;
        IStrategoTerm[] secondKids;
        if (!TermUtils.isAppl(second)) {
            return false;
        }
        IStrategoAppl o = (IStrategoAppl)second;
        if (this.getConstructor() != o.getConstructor()) {
            return false;
        }
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids != (secondKids = o.getAllSubterms())) {
            int i = 0;
            int sz = kids.length;
            while (i < sz) {
                IStrategoTerm kid = kids[i];
                IStrategoTerm secondKid = secondKids[i];
                if (kid != secondKid && !kid.match(secondKid)) {
                    return false;
                }
                ++i;
            }
        }
        if ((annotations = this.getAnnotations()) == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    public final void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(this.getName());
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            output.append('(');
            if (maxDepth == 0) {
                output.append("...");
            } else {
                kids[0].writeAsString(output, maxDepth - 1);
                int i = 1;
                while (i < kids.length) {
                    output.append(',');
                    kids[i].writeAsString(output, maxDepth - 1);
                    ++i;
                }
            }
            output.append(')');
        }
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    @Deprecated
    public final void prettyPrint(ITermPrinter pp) {
        new NotImplementedException();
    }

    @Override
    protected final int hashFunction() {
        long r = this.getConstructor().hashCode();
        int accum = 6673;
        IStrategoTerm[] kids = this.getAllSubterms();
        int i = 0;
        while (i < kids.length) {
            r += (long)(kids[i].hashCode() * accum);
            accum *= 7703;
            ++i;
        }
        return (int)(r >> 12);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new ArrayIterator<IStrategoTerm>(this.getAllSubterms());
    }
}

