/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import java.util.stream.StreamSupport;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.TermFactory;

public final class TermList
extends AbstractList<IStrategoTerm>
implements RandomAccess,
Serializable {
    private static final TermList EMPTY = new TermList(TermFactory.EMPTY_TERM_ARRAY);
    private final IStrategoTerm[] array;

    public static TermList fromIterable(Iterable<IStrategoTerm> terms) {
        if (terms instanceof TermList) {
            return (TermList)terms;
        }
        if (terms instanceof Collection) {
            Collection collection = (Collection)terms;
            if (collection.size() == 0) {
                return EMPTY;
            }
            IStrategoTerm[] array = collection.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY);
            return new TermList(array);
        }
        IStrategoTerm[] array = (IStrategoTerm[])StreamSupport.stream(terms.spliterator(), false).toArray(IStrategoTerm[]::new);
        if (array.length == 0) {
            return EMPTY;
        }
        return new TermList(array);
    }

    public static TermList of(IStrategoTerm ... terms) {
        if (terms.length == 0) {
            return EMPTY;
        }
        IStrategoTerm[] array = (IStrategoTerm[])terms.clone();
        return new TermList(array);
    }

    public static TermList ofUnsafe(IStrategoTerm ... terms) {
        if (terms.length == 0) {
            return EMPTY;
        }
        return new TermList(terms);
    }

    public static TermList of() {
        return EMPTY;
    }

    private TermList(IStrategoTerm[] array) {
        this.array = array;
    }

    @Override
    public IStrategoTerm get(int index) {
        return this.array[index];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.array);
    }
}

