/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoAppl;
import org.spoofax.terms.StrategoInt;
import org.spoofax.terms.StrategoList;
import org.spoofax.terms.StrategoPlaceholder;
import org.spoofax.terms.StrategoReal;
import org.spoofax.terms.StrategoString;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.StrategoTuple;
import org.spoofax.terms.util.StringInterner;
import org.spoofax.terms.util.TermUtils;

public class TermFactory
extends AbstractTermFactory
implements ITermFactory {
    private static final int MAX_POOLED_STRING_LENGTH = 200;
    private static final StringInterner usedStrings = new StringInterner();
    private IStrategoConstructor placeholderConstructor;

    @Override
    public IStrategoAppl makeAppl(IStrategoConstructor ctr, IStrategoTerm[] terms, @Nullable IStrategoList annotations) {
        assert (ctr.getArity() == terms.length);
        return new StrategoAppl(ctr, terms, annotations);
    }

    @Override
    public IStrategoInt makeInt(int i) {
        return new StrategoInt(i, null);
    }

    @Override
    public IStrategoList makeList() {
        return new StrategoList(null);
    }

    @Override
    public IStrategoList makeList(IStrategoTerm[] terms, @Nullable IStrategoList outerAnnos) {
        IStrategoTerm head;
        IStrategoList result = this.makeList();
        int i = terms.length - 1;
        while (i > 0) {
            head = terms[i--];
            result = new StrategoList(head, result, null);
        }
        if (i != 0) {
            if (outerAnnos == null || outerAnnos.isEmpty()) {
                return this.makeList();
            }
            return new StrategoList(outerAnnos);
        }
        head = terms[0];
        result = new StrategoList(head, result, outerAnnos);
        return result;
    }

    @Override
    public IStrategoList makeListCons(IStrategoTerm head, IStrategoList tail, @Nullable IStrategoList annotations) {
        if (head == null) {
            return this.makeList();
        }
        return new StrategoList(head, tail, annotations);
    }

    @Override
    public IStrategoReal makeReal(double d) {
        return new StrategoReal(d, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoString makeString(String s) {
        if (s.length() <= 200) {
            StringInterner stringInterner = usedStrings;
            synchronized (stringInterner) {
                s = usedStrings.intern(s);
            }
        }
        return new StrategoString(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStrategoString tryMakeUniqueString(String s) {
        StringInterner stringInterner = usedStrings;
        synchronized (stringInterner) {
            block5: {
                if (!usedStrings.contains(s)) break block5;
                return null;
            }
            if (s.length() > 200) {
                throw new UnsupportedOperationException("String too long to be pooled (newname not allowed): " + s);
            }
            return this.makeString(s);
        }
    }

    @Override
    public IStrategoTuple makeTuple(IStrategoTerm[] terms, @Nullable IStrategoList annos) {
        return new StrategoTuple(terms, annos);
    }

    @Override
    public IStrategoTerm annotateTerm(IStrategoTerm term, @Nullable IStrategoList annotations) {
        IStrategoList currentAnnos = term.getAnnotations();
        if (currentAnnos == annotations) {
            return term;
        }
        if (annotations.isEmpty() && TermUtils.isString(term)) {
            return this.makeString(((IStrategoString)term).stringValue());
        }
        if (term instanceof StrategoTerm) {
            StrategoTerm result = ((StrategoTerm)term).clone(true);
            result.internalSetAnnotations(annotations);
            return result;
        }
        throw new UnsupportedOperationException("Unable to annotate term of type " + term.getClass().getName() + " in " + this.getClass().getName());
    }

    @Override
    public IStrategoPlaceholder makePlaceholder(IStrategoTerm template) {
        if (this.placeholderConstructor == null) {
            this.placeholderConstructor = this.makeConstructor("<>", 1);
        }
        return new StrategoPlaceholder(this.placeholderConstructor, template, EMPTY_LIST);
    }
}

