/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermList;
import org.spoofax.terms.util.ArrayIterator;
import org.spoofax.terms.util.TermUtils;

public class StrategoTuple
extends StrategoTerm
implements IStrategoTuple {
    private static final long serialVersionUID = -6034069486754146955L;
    private final IStrategoTerm[] kids;

    public StrategoTuple(IStrategoTerm[] kids, @Nullable IStrategoList annotations) {
        super(annotations);
        this.kids = kids;
    }

    @Override
    public IStrategoTerm get(int index) {
        return this.kids[index];
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return this.kids;
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return TermList.ofUnsafe(this.kids);
    }

    @Override
    public int size() {
        return this.kids.length;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        return this.kids[index];
    }

    @Override
    public int getSubtermCount() {
        return this.kids.length;
    }

    @Override
    public TermType getType() {
        return TermType.TUPLE;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        if (!TermUtils.isTuple(second)) {
            return false;
        }
        IStrategoTuple snd = (IStrategoTuple)second;
        if (this.size() != snd.size()) {
            return false;
        }
        IStrategoTerm[] kids = this.kids;
        IStrategoTerm[] secondKids = snd.getAllSubterms();
        if (kids.length != secondKids.length) {
            return false;
        }
        int i = 0;
        int sz = kids.length;
        while (i < sz) {
            IStrategoTerm kid = kids[i];
            IStrategoTerm secondKid = secondKids[i];
            if (kid != secondKid && !kid.match(secondKid)) {
                return false;
            }
            ++i;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        int sz = this.size();
        if (sz > 0) {
            pp.println("(");
            pp.indent(2);
            this.get(0).prettyPrint(pp);
            int i = 1;
            while (i < sz) {
                pp.print(",");
                pp.nextIndentOff();
                this.get(i).prettyPrint(pp);
                pp.println("");
                ++i;
            }
            pp.println("");
            pp.print(")");
            pp.outdent(2);
        } else {
            pp.print("()");
        }
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append('(');
        IStrategoTerm[] kids = this.getAllSubterms();
        if (kids.length > 0) {
            if (maxDepth == 0) {
                output.append("...");
            } else {
                kids[0].writeAsString(output, maxDepth - 1);
                int i = 1;
                while (i < kids.length) {
                    output.append(',');
                    kids[i].writeAsString(output, maxDepth - 1);
                    ++i;
                }
            }
        }
        output.append(')');
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        long hc = 4831L;
        IStrategoTerm[] kids = this.getAllSubterms();
        int i = 0;
        while (i < kids.length) {
            hc *= (long)kids[i].hashCode();
            ++i;
        }
        return (int)(hc >> 10);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new ArrayIterator<IStrategoTerm>(this.kids);
    }
}

