/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermPrinter;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.terms.StrategoTerm;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.EmptyIterator;
import org.spoofax.terms.util.TermUtils;

public class StrategoReal
extends StrategoTerm
implements IStrategoReal {
    private static final long serialVersionUID = 9005617684098182139L;
    private final double value;

    public StrategoReal(double value, @Nullable IStrategoList annotations) {
        super(annotations);
        this.value = value;
    }

    protected StrategoReal(double value) {
        this(value, null);
    }

    @Override
    public double realValue() {
        return this.value;
    }

    @Override
    public List<IStrategoTerm> getSubterms() {
        return Collections.emptyList();
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return TermFactory.EMPTY_TERM_ARRAY;
    }

    @Override
    public int getSubtermCount() {
        return 0;
    }

    @Override
    public TermType getType() {
        return TermType.REAL;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        if (!TermUtils.isReal(second)) {
            return false;
        }
        if (this.realValue() != ((IStrategoReal)second).realValue()) {
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    @Deprecated
    public void prettyPrint(ITermPrinter pp) {
        pp.print("" + this.realValue());
        this.printAnnotations(pp);
    }

    @Override
    public void writeAsString(Appendable output, int maxDepth) throws IOException {
        output.append(Double.toString(this.realValue()));
        this.appendAnnotations(output, maxDepth);
    }

    @Override
    public int hashFunction() {
        return (int)(449.0 * this.value) ^ 0x1EA1;
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new EmptyIterator<IStrategoTerm>();
    }
}

