/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.stack.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.collections.IActiveStacks;
import org.spoofax.jsglr2.stack.collections.IForActorStacks;

public class ActiveStacksArrayList<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>>
implements IActiveStacks<StackNode> {
    protected ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing;
    protected List<StackNode> activeStacks;

    public ActiveStacksArrayList(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing) {
        this.observing = observing;
        this.activeStacks = new ArrayList<StackNode>();
    }

    @Override
    public void add(StackNode stack) {
        this.observing.notify(observer -> observer.addActiveStack(stack));
        this.activeStacks.add(stack);
    }

    @Override
    public boolean isSingle() {
        return this.activeStacks.size() == 1;
    }

    @Override
    public StackNode getSingle() {
        return (StackNode)((IStackNode)this.activeStacks.get(0));
    }

    @Override
    public boolean isEmpty() {
        return this.activeStacks.isEmpty();
    }

    @Override
    public boolean isMultiple() {
        return this.activeStacks.size() > 1;
    }

    @Override
    public StackNode findWithState(IState state) {
        this.observing.notify(observer -> observer.findActiveStackWithState(state));
        for (IStackNode stack : this.activeStacks) {
            if (stack.state().id() != state.id()) continue;
            return (StackNode)stack;
        }
        return null;
    }

    @Override
    public Iterable<StackNode> forLimitedReductions(final IForActorStacks<StackNode> forActorStacks) {
        return () -> new Iterator<StackNode>(){
            int index = 0;
            final int currentSize;
            {
                this.currentSize = ActiveStacksArrayList.this.activeStacks.size();
            }

            @Override
            public boolean hasNext() {
                while (this.index < this.currentSize && (((IStackNode)ActiveStacksArrayList.this.activeStacks.get(this.index)).allLinksRejected() || forActorStacks.contains((IStackNode)ActiveStacksArrayList.this.activeStacks.get(this.index)))) {
                    ++this.index;
                }
                return this.index < this.currentSize;
            }

            @Override
            public StackNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (IStackNode)ActiveStacksArrayList.this.activeStacks.get(this.index++);
            }
        };
    }

    @Override
    public void addAllTo(IForActorStacks<StackNode> other) {
        for (IStackNode stack : this.activeStacks) {
            other.add(stack);
        }
    }

    @Override
    public void clear() {
        this.activeStacks.clear();
    }

    @Override
    public Iterator<StackNode> iterator() {
        return this.activeStacks.iterator();
    }
}

