/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parser;

import java.util.Collection;
import org.spoofax.jsglr2.messages.Category;
import org.spoofax.jsglr2.messages.Message;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseNodeVisitor;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.parser.result.ParseFailureCause;

public class NonAssocDetector<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>>
implements ParseNodeVisitor<ParseForest, Derivation, ParseNode> {
    private final Collection<Message> messages;
    private ParseFailureCause.Type failure = null;

    NonAssocDetector(Collection<Message> messages) {
        this.messages = messages;
    }

    @Override
    public boolean preVisit(ParseNode parseNode, Position startPosition) {
        if (this.hasNonAssoc(parseNode)) {
            this.failure = ParseFailureCause.Type.NonAssoc;
            return false;
        }
        if (this.hasNonNested(parseNode)) {
            this.failure = ParseFailureCause.Type.NonNested;
            return false;
        }
        return parseNode.production().isContextFree();
    }

    @Override
    public void postVisit(ParseNode parseNode, Position startPosition, Position endPosition) {
        if (this.failure != null) {
            this.messages.add(new Message(this.failure.message, Category.NON_ASSOC, startPosition, endPosition));
            this.failure = null;
        }
    }

    private boolean hasNonAssoc(ParseNode parseNode) {
        for (IDerivation derivation : parseNode.getDerivations()) {
            IParseForest firstChild;
            IParseForest[] children = derivation.parseForests();
            if (children.length == 0 || !((firstChild = children[0]) instanceof IParseNode) || !derivation.production().isNonAssocWith(((IParseNode)firstChild).production())) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonNested(ParseNode parseNode) {
        for (IDerivation derivation : parseNode.getDerivations()) {
            IParseForest lastChild;
            IParseForest[] children = derivation.parseForests();
            if (children.length == 0 || !((lastChild = children[children.length - 1]) instanceof IParseNode) || !derivation.production().isNonNestedWith(((IParseNode)lastChild).production())) continue;
            return true;
        }
        return false;
    }
}

