/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental.diff.jgit;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.spoofax.jsglr2.incremental.diff.jgit.IntList;
import org.spoofax.jsglr2.incremental.diff.jgit.Sequence;

public class RawText
extends Sequence {
    public static final RawText EMPTY_TEXT = new RawText(new char[0], new IntList());
    static final int FIRST_FEW_BYTES = 8000;
    protected final char[] content;
    protected final IntList lines;

    public RawText(char[] input, IntList lineMap) {
        this.content = input;
        this.lines = lineMap;
    }

    public char[] getRawContent() {
        return this.content;
    }

    @Override
    public int size() {
        return this.lines.size() - 2;
    }

    public void writeLine(OutputStream out, int i) throws IOException {
        int start = this.getStart(i);
        int end = this.getEnd(i);
        if (this.content[end - 1] == '\n') {
            --end;
        }
        out.write(new String(this.content).getBytes(), start, end - start);
    }

    public boolean isMissingNewlineAtEnd() {
        int end = this.lines.get(this.lines.size() - 1);
        if (end == 0) {
            return true;
        }
        return this.content[end - 1] != '\n';
    }

    private int getStart(int i) {
        return this.lines.get(i + 1);
    }

    private int getEnd(int i) {
        return this.lines.get(i + 2);
    }

    public static boolean isBinary(byte[] raw) {
        return RawText.isBinary(raw, raw.length);
    }

    public static boolean isBinary(InputStream raw) throws IOException {
        byte[] buffer = new byte[8000];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isBinary(buffer, cnt);
    }

    public static boolean isBinary(byte[] raw, int length) {
        if (length > 8000) {
            length = 8000;
        }
        int ptr = 0;
        while (ptr < length) {
            if (raw[ptr] == 0) {
                return true;
            }
            ++ptr;
        }
        return false;
    }

    public static boolean isCrLfText(byte[] raw) {
        return RawText.isCrLfText(raw, raw.length);
    }

    public static boolean isCrLfText(InputStream raw) throws IOException {
        byte[] buffer = new byte[8000];
        int cnt = 0;
        while (cnt < buffer.length) {
            int n = raw.read(buffer, cnt, buffer.length - cnt);
            if (n == -1) break;
            cnt += n;
        }
        return RawText.isCrLfText(buffer, cnt);
    }

    public static boolean isCrLfText(byte[] raw, int length) {
        boolean has_crlf = false;
        int ptr = 0;
        while (ptr < length - 1) {
            if (raw[ptr] == 0) {
                return false;
            }
            if (raw[ptr] == 13 && raw[ptr + 1] == 10) {
                has_crlf = true;
            }
            ++ptr;
        }
        return has_crlf;
    }

    public String getLineDelimiter() {
        if (this.size() == 0) {
            return null;
        }
        int e = this.getEnd(0);
        if (this.content[e - 1] != '\n') {
            return null;
        }
        if (this.content.length > 1 && e > 1 && this.content[e - 2] == '\r') {
            return "\r\n";
        }
        return "\n";
    }
}

