/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.FineGrainedRecovery;
import org.spoofax.jsglr.client.FineGrainedSetting;
import org.spoofax.jsglr.client.IntegratedRecoverySettings;
import org.spoofax.jsglr.client.ParserHistory;
import org.spoofax.jsglr.client.RegionRecovery;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.StructureSkipSuggestion;
import org.spoofax.jsglr.client.TokenOffset;

public class RecoveryConnector {
    private SGLR mySGLR;
    private IntegratedRecoverySettings settings;
    private RegionRecovery regionSelector;
    private FineGrainedRecovery fgRegionalRecovery;
    private FineGrainedRecovery fgCursorLineRecovery;

    public void setFgRegionalRecovery(FineGrainedRecovery fgRegionalRecovery) {
        this.fgRegionalRecovery = fgRegionalRecovery;
    }

    private ParserHistory getHistory() {
        return this.mySGLR.getHistory();
    }

    public RecoveryConnector(SGLR parser) {
        this(parser, IntegratedRecoverySettings.createDefaultSettings(), FineGrainedSetting.createDefaultSetting());
    }

    public RecoveryConnector(SGLR parser, IntegratedRecoverySettings settings) {
        this(parser, settings, FineGrainedSetting.createDefaultSetting());
    }

    public int getMaxNumberOfRecoverApplicationsGlobal() {
        return this.settings.getMaxNumberOfRecoverApplicationsGlobal();
    }

    public RecoveryConnector(SGLR parser, IntegratedRecoverySettings settings, FineGrainedSetting fgSettings) {
        this.mySGLR = parser;
        this.regionSelector = new RegionRecovery(this.mySGLR);
        this.settings = settings;
        this.fgCursorLineRecovery = new FineGrainedRecovery(this.mySGLR, FineGrainedSetting.createCursorLineSetting());
        this.fgRegionalRecovery = new FineGrainedRecovery(this.mySGLR, fgSettings);
    }

    public void recover() throws InterruptedException {
        this.mySGLR.getPerformanceMeasuring().startRecovery();
        boolean recoverySucceeded = this.combinedRecover();
        this.mySGLR.getPerformanceMeasuring().endRecovery(recoverySucceeded);
    }

    private boolean combinedRecover() throws InterruptedException {
        int failureOffset = this.mySGLR.getParserLocation();
        int failureLineIndex = this.getHistory().getLineOfTokenPosition(failureOffset - 1);
        int cursorLineIndex = this.getHistory().getLineOfTokenPosition(this.mySGLR.getCursorLocation());
        this.mySGLR.getPerformanceMeasuring().addFailureLocation(failureOffset);
        if (this.settings.useFineGrained() && this.settings.useCursorLocation() && this.tryFineGrainedOnCursorLine(failureOffset, failureLineIndex, cursorLineIndex)) {
            return true;
        }
        boolean skipSucceeded = false;
        if (this.settings.useRegionSelection() || this.settings.useRegionRecovery()) {
            skipSucceeded = this.trySelectErroneousRegion(failureOffset, failureLineIndex, cursorLineIndex);
        }
        if (this.settings.useFineGrained()) {
            boolean fgSucceeded = this.tryFineGrainedRecovery(failureOffset, failureLineIndex, skipSucceeded);
            if (this.parseRemainingTokens(true)) {
                return true;
            }
            if (fgSucceeded && this.mySGLR.getParserLocation() > failureOffset) {
                return this.combinedRecover();
            }
        }
        if (this.settings.useRegionRecovery() && skipSucceeded) {
            this.parseErrorFragmentAsWhiteSpace();
            if (this.parseRemainingTokens(true)) {
                return true;
            }
            if (this.mySGLR.getParserLocation() > failureOffset) {
                return this.combinedRecover();
            }
        }
        return false;
    }

    private boolean tryFineGrainedOnCursorLine(int failureOffset, int failureLineIndex, int cursorLineIndex) throws InterruptedException {
        if (this.isLikelyErrorLocation(failureLineIndex, cursorLineIndex)) {
            this.mySGLR.getPerformanceMeasuring().startFGOnCursor();
            boolean fgSucceededOnCursor = this.fgCursorLineRecovery.recover(failureOffset, cursorLineIndex);
            this.mySGLR.getPerformanceMeasuring().endFGOnCursor(fgSucceededOnCursor);
            if (fgSucceededOnCursor && this.parseRemainingTokens(true)) {
                return true;
            }
        }
        return false;
    }

    private boolean trySelectErroneousRegion(int failureOffset, int failureLineIndex, int cursorLineIndex) throws InterruptedException {
        this.mySGLR.getPerformanceMeasuring().startCG();
        boolean skipSucceeded = this.settings.useCursorLocation() && this.isPossibleErrorLocation(failureLineIndex, cursorLineIndex) ? this.regionSelector.selectErroneousFragment(failureOffset, failureLineIndex, cursorLineIndex) : this.regionSelector.selectErroneousFragment(failureOffset, failureLineIndex);
        this.mySGLR.getPerformanceMeasuring().endCG(skipSucceeded);
        this.mySGLR.acceptingStack = null;
        this.mySGLR.activeStacks.clear();
        return skipSucceeded;
    }

    private boolean tryFineGrainedRecovery(int failureOffset, int failureLineIndex, boolean skipSucceeded) throws InterruptedException {
        this.mySGLR.getPerformanceMeasuring().startFG();
        boolean fgSucceeded = false;
        if (skipSucceeded && this.settings.useRegionSelection()) {
            StructureSkipSuggestion erroneousRegion = this.regionSelector.getErroneousRegion();
            fgSucceeded = this.fgRegionalRecovery.recover(failureOffset, Math.min(erroneousRegion.getIndexHistoryEnd(), failureLineIndex), erroneousRegion.getStartSkip().getTokensSeen(), erroneousRegion.getEndSkip().getTokensSeen());
        } else {
            fgSucceeded = this.fgRegionalRecovery.recover(failureOffset, failureLineIndex);
        }
        this.mySGLR.getPerformanceMeasuring().endFG(fgSucceeded);
        return fgSucceeded;
    }

    private boolean isLikelyErrorLocation(int failureLineIndex, int cursorLineIndex) {
        return this.isPossibleErrorLocation(failureLineIndex, cursorLineIndex) && failureLineIndex - cursorLineIndex <= 10;
    }

    private boolean isPossibleErrorLocation(int failureLineIndex, int cursorLineIndex) {
        return this.mySGLR.isSetCursorLocation() && failureLineIndex >= cursorLineIndex;
    }

    public boolean parseRemainingTokens(boolean keepHistory) throws InterruptedException {
        while (!this.getHistory().hasFinishedRecoverTokens() && this.mySGLR.activeStacks.size() > 0 && this.mySGLR.acceptingStack == null) {
            this.getHistory().readRecoverToken(this.mySGLR, keepHistory);
            this.mySGLR.doParseStep();
        }
        return this.recoverySucceeded();
    }

    private boolean recoverySucceeded() {
        return this.mySGLR.activeStacks.size() > 0 || this.mySGLR.acceptingStack != null;
    }

    public boolean parseErrorFragmentAsWhiteSpace() throws InterruptedException {
        this.mySGLR.activeStacks.clear();
        this.mySGLR.activeStacks.addAll(this.regionSelector.getStartLineErrorFragment().getStackNodes());
        this.getHistory().setTokenIndex(this.regionSelector.getStartPositionErrorFragment());
        this.getHistory().resetRecoveryIndentHandler(this.regionSelector.getStartLineErrorFragment().getIndentValue());
        while (this.getHistory().getTokenIndex() < this.regionSelector.getEndPositionErrorFragment() && this.mySGLR.activeStacks.size() > 0 && this.mySGLR.acceptingStack == null) {
            this.getHistory().readRecoverToken(this.mySGLR, false);
            this.parseAsLayout();
        }
        return this.recoverySucceeded();
    }

    private void parseAsLayout() throws InterruptedException {
        if (!RecoveryConnector.isLayoutCharacter((char)this.mySGLR.getCurrentToken().getToken()) && this.mySGLR.getCurrentToken().getToken() != -1) {
            this.mySGLR.setCurrentToken(new TokenOffset(32, this.mySGLR.getCurrentToken().getOffset()));
        }
        this.mySGLR.doParseStep();
    }

    public static boolean isLayoutCharacter(int aChar) {
        return aChar == 32 || aChar == 9 || aChar == 10;
    }
}

