/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class RangeList
implements Serializable {
    private static final long serialVersionUID = 16593569L;
    public static final int NONE = -2;
    private final int[] ranges;
    private final boolean containsEOF;
    private final int singularRange;

    public RangeList(int[] ranges, boolean containsEOF) {
        this.containsEOF = containsEOF;
        if (!containsEOF && (ranges.length == 1 || ranges.length == 2 && ranges[0] == ranges[1])) {
            this.ranges = null;
            this.singularRange = ranges[0];
        } else if (ranges.length == 0 && containsEOF) {
            this.ranges = null;
            this.singularRange = -1;
        } else {
            this.ranges = ranges;
            this.singularRange = -2;
        }
    }

    public final boolean within(int c) {
        if (c == -1) {
            return this.containsEOF;
        }
        if (this.ranges == null) {
            return c == this.singularRange;
        }
        int i = 0;
        while (i < this.ranges.length) {
            int low = this.ranges[i];
            if (low <= c) {
                int high = this.ranges[i + 1];
                if (c <= high) {
                    return true;
                }
            } else {
                return false;
            }
            i += 2;
        }
        return false;
    }

    public int getSingularRange() {
        return this.singularRange;
    }

    public int getFirstRangeElement() {
        return this.ranges == null ? this.singularRange : this.ranges[0];
    }

    public int getLastRangeElement() {
        return this.ranges == null ? this.singularRange : this.ranges[this.ranges.length - 1];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeList)) {
            return false;
        }
        RangeList rangeList = (RangeList)obj;
        return this.containsEOF == rangeList.containsEOF && this.singularRange == rangeList.singularRange && Arrays.equals(this.ranges, rangeList.ranges);
    }

    public int hashCode() {
        int result = Objects.hash(this.containsEOF, this.singularRange);
        result = 31 * result + Arrays.hashCode(this.ranges);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.singularRange != -2) {
            sb.append(this.singularRange);
        } else {
            sb.append('[');
            int i = 0;
            int end = this.ranges.length - 1;
            while (i < end) {
                int low = this.ranges[i];
                int high = this.ranges[i + 1];
                sb.append(low);
                if (low != high) {
                    sb.append('-');
                    sb.append(high);
                }
                sb.append(',');
                i += 2;
            }
            sb.replace(sb.length() - 1, sb.length(), "]");
        }
        return sb.toString();
    }
}

