/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.AmbiguityManager;
import org.spoofax.jsglr.client.FatalException;
import org.spoofax.jsglr.client.FilterException;
import org.spoofax.jsglr.client.Label;
import org.spoofax.jsglr.client.ParseNode;
import org.spoofax.jsglr.client.ParseProductionNode;
import org.spoofax.jsglr.client.ParseTable;
import org.spoofax.jsglr.client.PositionMap;
import org.spoofax.jsglr.client.Priority;
import org.spoofax.jsglr.client.SGLR;
import org.spoofax.jsglr.client.StartSymbolException;
import org.spoofax.jsglr.client.Timer;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.jsglr.client.indentation.LayoutFilter;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.jsglr.shared.Tools;
import org.spoofax.terms.Term;
import org.spoofax.terms.util.NotImplementedException;

public class Disambiguator {
    private static final boolean LAYOUT_FITERING = true;
    private static final int FILTER_DRAW = 1;
    private static final int FILTER_LEFT_WINS = 2;
    private static final int FILTER_RIGHT_WINS = 3;
    private boolean filterAny;
    private boolean filterCycles;
    private boolean filterDirectPreference;
    private boolean filterPreferenceCount;
    private boolean filterInjectionCount;
    private boolean filterLongestMatch;
    private boolean filterTopSort;
    private boolean filterReject;
    private boolean filterAssociativity;
    private boolean filterPriorities;
    private boolean filterStrict;
    private boolean logStatistics;
    private boolean ambiguityIsError;
    private int ambiguityCount;
    private int newAmbiguityCount;
    private AmbiguityManager ambiguityManager;
    private SGLR parser;
    ParseTable parseTable;
    private ProductionAttributeReader prodReader;
    private LayoutFilter layoutFilter;
    private int layoutFiltering;
    private long timeout = Long.MAX_VALUE;

    public final void setFilterAny(boolean filterAny) {
        this.filterAny = filterAny;
    }

    public final void setFilterDirectPreference(boolean filterDirectPreference) {
        this.filterDirectPreference = filterDirectPreference;
    }

    public boolean getFilterDirectPreference() {
        return this.filterDirectPreference;
    }

    @Deprecated
    public final void setFilterIndirectPreference(boolean filterIndirectPreference) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean getFilterIndirectPreference() {
        throw new UnsupportedOperationException();
    }

    public final void setFilterInjectionCount(boolean filterInjectionCount) {
        this.filterInjectionCount = filterInjectionCount;
    }

    public boolean getFilterInjectionCount() {
        return this.filterInjectionCount;
    }

    public final void setFilterLongestMatch(boolean filterLongestMatch) {
        this.filterLongestMatch = filterLongestMatch;
    }

    public boolean getLongestMatch() {
        return this.filterLongestMatch;
    }

    public final void setFilterPreferenceCount(boolean filterPreferenceCount) {
        this.filterPreferenceCount = filterPreferenceCount;
    }

    public boolean getFilterPreferenceCount() {
        return this.filterPreferenceCount;
    }

    public final void setFilterTopSort(boolean filterTopSort) {
        this.filterTopSort = filterTopSort;
    }

    public boolean getFilterTopSort() {
        return this.filterTopSort;
    }

    public void setFilterCycles(boolean filterCycles) {
        this.filterCycles = filterCycles;
    }

    public boolean isFilterCycles() {
        return this.filterCycles;
    }

    public void setFilterAssociativity(boolean filterAssociativity) {
        this.filterAssociativity = filterAssociativity;
    }

    public boolean getFilterAssociativity() {
        return this.filterAssociativity;
    }

    public void setFilterPriorities(boolean filterPriorities) {
        this.filterPriorities = filterPriorities;
    }

    public boolean getFilterPriorities() {
        return this.filterPriorities;
    }

    public void setFilterStrict(boolean filterStrict) {
        this.filterStrict = filterStrict;
    }

    public boolean getFilterStrict() {
        return this.filterStrict;
    }

    public final void setHeuristicFilters(boolean heuristicFilters) {
        this.setFilterPreferenceCount(heuristicFilters);
        this.setFilterInjectionCount(heuristicFilters);
    }

    public void setFilterReject(boolean filterReject) {
        this.filterReject = filterReject;
    }

    public boolean getFilterReject() {
        return this.filterReject;
    }

    public void setLogStatistics(boolean logStatistics) {
        this.logStatistics = logStatistics;
    }

    public boolean getLogStatistics() {
        return this.logStatistics;
    }

    public void setAmbiguityIsError(boolean ambiguityIsError) {
        this.ambiguityIsError = ambiguityIsError;
    }

    public boolean getAmbiguityIsError() {
        return this.ambiguityIsError;
    }

    public int getAmbiguityCount() {
        return this.newAmbiguityCount;
    }

    public int getLayoutFilteringCount() {
        return this.layoutFiltering;
    }

    public int getLayoutFilterCallCount() {
        return this.layoutFilter == null ? 0 : this.layoutFilter.getFilterCallCount();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final void setDefaultFilters() {
        this.filterAny = true;
        this.filterCycles = false;
        this.filterDirectPreference = true;
        this.filterPreferenceCount = false;
        this.filterInjectionCount = false;
        this.filterLongestMatch = true;
        this.filterTopSort = true;
        this.filterReject = true;
        this.filterAssociativity = true;
        this.filterPriorities = true;
        this.filterStrict = false;
        this.logStatistics = true;
        this.ambiguityIsError = false;
    }

    public Disambiguator() {
        this.setDefaultFilters();
    }

    public Object applyFilters(SGLR parser, AbstractParseNode root, String sort, int inputLength) throws SGLRException, FilterException, InterruptedException {
        return this.applyFilters(parser, root, sort, 0, inputLength);
    }

    public Object applyFilters(SGLR parser, AbstractParseNode root, String sort, int startOffset, int inputLength) throws SGLRException, FilterException, InterruptedException {
        AbstractParseNode t = root;
        try {
            this.initializeFromParser(parser);
            t = this.applyTopSortFilter(sort, t);
            if (this.filterAny) {
                t = this.applyCycleDetectFilter(t);
                this.ambiguityManager.resetClustersVisitedCount();
                Timer timer = new Timer();
                timer.start();
                t = this.filterTree(t, timer);
                timer.reset();
            }
            if (t == null) {
                return null;
            }
        }
        catch (RuntimeException e) {
            throw new FilterException(parser, "Runtime exception when applying filters", e);
        }
        {
            this.newAmbiguityCount = t.getAmbiguityCount();
        }
        Object object = this.yieldTreeTop(t, startOffset);
        return object;
        finally {
            this.initializeFromParser(null);
        }
    }

    public void initializeFromParser(SGLR parser) {
        if (parser == null) {
            this.parser = null;
            this.parseTable = null;
            this.ambiguityCount += this.ambiguityManager == null ? 0 : this.ambiguityManager.getAmbiguitiesCount();
            this.ambiguityManager = null;
            this.layoutFilter = null;
        } else {
            this.parser = parser;
            this.parseTable = parser.getParseTable();
            this.prodReader = new ProductionAttributeReader(this.parseTable.getFactory());
            this.ambiguityManager = parser.getAmbiguityManager();
            this.ambiguityCount = 0;
            this.layoutFilter = new LayoutFilter(this.parseTable, false);
            this.layoutFiltering = 0;
        }
    }

    private void logStatus() {
        Tools.logger("Number of rejects: ", this.parser.getRejectCount());
        Tools.logger("Number of reductions: ", this.parser.getReductionCount());
        Tools.logger("Number of ambiguities: ", this.ambiguityManager.getMaxNumberOfAmbiguities());
        Tools.logger("Number of calls to Amb: ", this.ambiguityManager.getAmbiguityCallsCount());
        Tools.logger("Count Eagerness Comparisons: ", this.ambiguityManager.getEagernessComparisonCount(), " / ", this.ambiguityManager.getEagernessSucceededCount());
        Tools.logger("Number of Injection Counts: ", this.ambiguityManager.getInjectionCount());
    }

    private Object yieldTree(AbstractParseNode t, int startOffset) {
        this.parser.getTreeBuilder().reset(startOffset);
        return this.parser.getTreeBuilder().buildTree(t);
    }

    private Object yieldTreeTop(AbstractParseNode t, int startOffset) throws SGLRException {
        int ambCount = this.ambiguityManager.getAmbiguitiesCount();
        try {
            this.ambiguityCount += this.ambiguityManager.getAmbiguitiesCount();
            this.ambiguityManager.resetAmbiguityCount();
            Object r = this.yieldTree(t, startOffset);
            if (r == null) {
                return null;
            }
            if (this.logStatistics) {
                this.logStatus();
            }
            if (this.ambiguityIsError && ambCount > 0) {
                throw new SGLRException(this.parser, "Ambiguities found");
            }
            Object object = this.parser.getTreeBuilder().buildTreeTop(r, ambCount);
            return object;
        }
        finally {
            this.parser.getTreeBuilder().reset();
        }
    }

    private AbstractParseNode applyCycleDetectFilter(AbstractParseNode t) throws FilterException {
        if (this.filterCycles && this.ambiguityManager.getMaxNumberOfAmbiguities() > 0 && this.isCyclicTerm(t)) {
            throw new FilterException(this.parser, "Term is cyclic");
        }
        return t;
    }

    private IStrategoTerm getProduction(AbstractParseNode t) {
        if (t.isParseNode()) {
            return this.parseTable.getProduction(((ParseNode)t).getLabel());
        }
        return this.parseTable.getProduction(((ParseProductionNode)t).getLabel());
    }

    protected AbstractParseNode applyTopSortFilter(String sort, AbstractParseNode t) throws SGLRException {
        if (sort != null && this.filterTopSort && (t = this.selectOnTopSort(t, sort)) == null) {
            throw new StartSymbolException(this.parser, "Desired start symbol not found: " + sort);
        }
        return t;
    }

    private boolean matchProdOnTopSort(IStrategoTerm prod, String sort) throws FilterException {
        assert (sort != null);
        IStrategoList lhs = (IStrategoList)Term.termAt(prod, 0);
        IStrategoAppl rhs = (IStrategoAppl)Term.termAt(prod, 1);
        String foundSort = this.prodReader.tryGetFirstSort(lhs);
        assert (foundSort != null);
        assert ("<START>".equals(this.prodReader.tryGetSort(rhs)));
        return sort.equals(foundSort);
    }

    private AbstractParseNode selectOnTopSort(AbstractParseNode t, String sort) throws FilterException {
        ArrayList<AbstractParseNode> results = new ArrayList<AbstractParseNode>();
        if (t.isAmbNode()) {
            this.addTopSortAlternatives(t, sort, results);
            switch (results.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (AbstractParseNode)results.get(0);
                }
            }
            this.ambiguityManager.increaseAmbiguityCount();
            return ParseNode.createAmbNode(results.toArray(new AbstractParseNode[results.size()]));
        }
        IStrategoTerm prod = this.getProduction(t);
        return this.matchProdOnTopSort(prod, sort) ? t : null;
    }

    private void addTopSortAlternatives(AbstractParseNode t, String sort, List<AbstractParseNode> results) throws FilterException {
        AbstractParseNode[] abstractParseNodeArray = t.getChildren();
        int n = abstractParseNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode amb = abstractParseNodeArray[n2];
            if (amb.isAmbNode()) {
                this.addTopSortAlternatives(amb, sort, results);
            } else {
                IStrategoTerm prod = this.getProduction(amb);
                if (this.matchProdOnTopSort(prod, sort)) {
                    results.add(amb);
                }
            }
            ++n2;
        }
    }

    public AbstractParseNode filterTree(AbstractParseNode node, Timer timer) throws FilterException, InterruptedException {
        if (timer.peek() > this.timeout) {
            throw new InterruptedException("Disambiguator timed out, this is usually caused by a very high number of layout ambiguities.");
        }
        LinkedList<AbstractParseNode> input = new LinkedList<AbstractParseNode>();
        LinkedList<AbstractParseNode> output = new LinkedList<AbstractParseNode>();
        LinkedList<AbstractParseNode> pending = new LinkedList<AbstractParseNode>();
        input.push(node);
        block6: while (!input.isEmpty() || !pending.isEmpty()) {
            AbstractParseNode t;
            int pendingPeekPos;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            int n = pendingPeekPos = pending.isEmpty() ? -1 : output.size() - ((AbstractParseNode)pending.peek()).getChildren().length - 1;
            if (!pending.isEmpty() && pendingPeekPos >= 0 && output.get(output.size() - pendingPeekPos - 1) == pending.peek()) {
                t = (AbstractParseNode)pending.pop();
                AbstractParseNode[] args = new AbstractParseNode[t.getChildren().length];
                boolean changed = false;
                boolean rejected = false;
                int i = t.getChildren().length - 1;
                while (i >= 0) {
                    args[i] = (AbstractParseNode)output.pop();
                    rejected = rejected || args[i] == null;
                    changed = changed || args[i] != t.getChildren()[i];
                    --i;
                }
                output.pop();
                if (!rejected && changed) {
                    t = new ParseNode(t.getLabel(), args, t.getNodeType(), t.getLine(), t.getColumn(), t.isLayout(), t.isIgnoreLayout(), t.isPlaceholderInsertionNode(), t.isLiteralCompletionNode(), t.isProposal(), t.isNestedProposal(), t.isSinglePlaceholderInsertion());
                }
                if (!rejected) {
                    if (!this.layoutFilter.hasValidLayout((ParseNode)t)) {
                        ++this.layoutFiltering;
                        rejected = true;
                    } else {
                        this.layoutFiltering += this.layoutFilter.getDisambiguationCount();
                    }
                    this.ambiguityManager.decreaseAmbiguityCount(this.layoutFilter.getDisambiguationCount());
                }
                if (rejected) {
                    return null;
                }
                output.push(t);
                continue;
            }
            t = (AbstractParseNode)input.pop();
            switch (t.getNodeType()) {
                case 3: {
                    if (!output.isEmpty()) {
                        if ((t = this.filterAmbiguities(t.getChildren(), timer)) == null) {
                            return null;
                        }
                        output.push(t);
                        break;
                    }
                    if (this.filterReject && t.isParseRejectNode()) {
                        output.push(t);
                        break;
                    }
                    output.push(this.filterAmbiguities(t.getChildren(), timer));
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    boolean rejected = false;
                    if (!rejected && this.filterReject && t.isParseRejectNode()) {
                        rejected = true;
                    }
                    if (!this.layoutFilter.hasValidLayout((ParseNode)t)) {
                        ++this.layoutFiltering;
                        rejected = true;
                    } else {
                        this.layoutFiltering += this.layoutFilter.getDisambiguationCount();
                    }
                    if (!rejected) {
                        boolean bl = rejected = (t = this.applyAssociativityPriorityFilter(t)) == null;
                    }
                    if (rejected) {
                        return null;
                    }
                    output.push(t);
                    if (t.getChildren().length <= 0 || t.isParseProductionChain()) continue block6;
                    pending.push(t);
                    int i = t.getChildren().length - 1;
                    while (i >= 0) {
                        input.push(t.getChildren()[i]);
                        --i;
                    }
                    continue block6;
                }
                case 1: {
                    output.push(t);
                    break;
                }
                case 7: {
                    output.push(t);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown node type: " + t);
                }
            }
        }
        assert (output.size() == 1);
        return (AbstractParseNode)output.peek();
    }

    private AbstractParseNode applyAssociativityPriorityFilter(AbstractParseNode t) {
        if (t.isParseNode()) {
            ParseNode n = (ParseNode)t;
            Label prodLabel = this.parseTable.getLabel(n.getLabel());
            if (this.filterAssociativity) {
                if (prodLabel.isLeftAssociative()) {
                    t = this.applyLeftAssociativeFilter(n, prodLabel);
                } else if (prodLabel.isRightAssociative()) {
                    t = this.applyRightAssociativeFilter(n, prodLabel);
                }
            }
            if (this.filterPriorities && this.parseTable.hasPriorities() && !this.lookupGtrPriority(prodLabel).isEmpty()) {
                return this.applyPriorityFilter(n, prodLabel);
            }
        }
        return t;
    }

    private AbstractParseNode applyRightAssociativeFilter(ParseNode t, Label prodLabel) {
        ArrayList<AbstractParseNode> newAmbiguities = new ArrayList<AbstractParseNode>();
        AbstractParseNode[] kids = t.getChildren();
        AbstractParseNode firstKid = kids[0];
        if (firstKid.isAmbNode()) {
            AbstractParseNode extraAmb;
            AbstractParseNode[] abstractParseNodeArray = firstKid.getChildren();
            int n = abstractParseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractParseNode amb = abstractParseNodeArray[n2];
                if (((ParseNode)amb).getLabel() != prodLabel.labelNumber) {
                    newAmbiguities.add(amb);
                }
                ++n2;
            }
            int additionalAmbNodes = newAmbiguities.isEmpty() ? 0 : 1;
            AbstractParseNode[] restKids = new AbstractParseNode[kids.length - 1 + additionalAmbNodes];
            System.arraycopy(kids, 1, restKids, 0, kids.length - 1);
            assert (!newAmbiguities.isEmpty());
            if (newAmbiguities.size() > 1) {
                extraAmb = ParseNode.createAmbNode(newAmbiguities.toArray(new AbstractParseNode[newAmbiguities.size()]));
                this.ambiguityManager.increaseAmbiguityCount();
            } else {
                extraAmb = (AbstractParseNode)newAmbiguities.get(0);
            }
            restKids[restKids.length - 1] = extraAmb;
            return new ParseNode(t.getLabel(), restKids, 2, t.getLine(), t.getColumn(), t.isLayout(), t.isIgnoreLayout(), t.isPlaceholderInsertionNode(), t.isLiteralCompletionNode(), t.isProposal(), t.isNestedProposal(), t.isSinglePlaceholderInsertion());
        }
        if (firstKid.isParseNode()) assert (((ParseNode)firstKid).getLabel() != prodLabel.labelNumber);
        return t;
    }

    /*
     * Unable to fully structure code
     */
    private AbstractParseNode applyPriorityFilter(ParseNode t, Label prodLabel) {
        newAmbiguities = new ArrayList<AbstractParseNode>();
        newKids = new ArrayList<AbstractParseNode>();
        l0 = prodLabel.labelNumber;
        kidnumber = 0;
        var10_7 = t.getChildren();
        var9_8 = var10_7.length;
        var8_9 = 0;
        while (var8_9 < var9_8) {
            newKid = kid = var10_7[var8_9];
            injection = this.jumpOverInjections(kid);
            if (!injection.isAmbNode()) ** GOTO lbl38
            newAmbiguities.clear();
            var16_17 = injection.getChildren();
            var15_16 = var16_17.length;
            var14_15 = 0;
            while (var14_15 < var15_16) {
                amb = var16_17[var14_15];
                injAmb = this.jumpOverInjections(amb);
                if (injAmb.isParseNode()) {
                    label = this.getProductionLabel(t);
                    if (this.hasGreaterPriority(l0, label.labelNumber, kidnumber)) {
                        newAmbiguities.add(amb);
                    }
                }
                ++var14_15;
            }
            if (!newAmbiguities.isEmpty()) {
                n = null;
                if (newAmbiguities.size() > 1) {
                    n = ParseNode.createAmbNode(newAmbiguities.toArray(new AbstractParseNode[newAmbiguities.size()]));
                    this.ambiguityManager.increaseAmbiguityCount();
                } else {
                    n = (AbstractParseNode)newAmbiguities.get(0);
                }
                newKid = this.replaceUnderInjections(kid, injection, n);
            } else {
                if (!Disambiguator.$assertionsDisabled && this.filterStrict) {
                    throw new AssertionError();
                }
                return t;
lbl38:
                // 1 sources

                if (injection.isParseNode()) {
                    l1 = ((ParseNode)injection).getLabel();
                    if (!Disambiguator.$assertionsDisabled && this.hasGreaterPriority(l0, l1, kidnumber)) {
                        throw new AssertionError();
                    }
                }
            }
            newKids.add(newKid);
            ++kidnumber;
            ++var8_9;
        }
        return new ParseNode(t.getLabel(), newKids.toArray(new AbstractParseNode[newKids.size()]), 2, t.getLine(), t.getColumn(), t.isLayout(), t.isIgnoreLayout(), t.isPlaceholderInsertionNode(), t.isLiteralCompletionNode(), t.isProposal(), t.isNestedProposal(), t.isSinglePlaceholderInsertion());
    }

    private AbstractParseNode replaceUnderInjections(AbstractParseNode alt, AbstractParseNode injection, AbstractParseNode n) {
        assert (false);
        return null;
    }

    private AbstractParseNode jumpOverInjections(AbstractParseNode t) {
        if (t.isParseNode()) {
            int prod = ((ParseNode)t).getLabel();
            ParseNode n = (ParseNode)t;
            while (this.isUserDefinedLabel(prod)) {
                AbstractParseNode x = n.kids[0];
                if (x.isParseNode()) {
                    n = (ParseNode)x;
                    prod = n.getLabel();
                    continue;
                }
                return x;
            }
        }
        return t;
    }

    private boolean isUserDefinedLabel(int prod) {
        Label l = this.parseTable.lookupInjection(prod);
        if (l == null) {
            return false;
        }
        return l.isInjection();
    }

    private boolean hasGreaterPriority(int l0, int l1, int arg) {
        List<Priority> prios = this.lookupGtrPriority(this.parseTable.getLabel(l0));
        int i = 0;
        int size = prios.size();
        while (i < size) {
            Priority p = prios.get(i);
            if (l1 == p.right && (p.arg == -1 || p.arg == arg)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List<Priority> lookupGtrPriority(Label prodLabel) {
        return this.parseTable.getPriorities(prodLabel);
    }

    private AbstractParseNode applyLeftAssociativeFilter(ParseNode t, Label prodLabel) {
        ArrayList<AbstractParseNode> newAmbiguities = new ArrayList<AbstractParseNode>();
        AbstractParseNode[] kids = t.kids;
        AbstractParseNode last = kids[kids.length - 1];
        if (last.isAmbNode()) {
            AbstractParseNode[] abstractParseNodeArray = last.getChildren();
            int n = abstractParseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractParseNode amb = abstractParseNodeArray[n2];
                if (amb.isAmbNode() || !this.parseTable.getLabel(((ParseNode)amb).getLabel()).equals(prodLabel)) {
                    newAmbiguities.add(amb);
                }
                ++n2;
            }
            assert (!newAmbiguities.isEmpty());
            AbstractParseNode[] rest = new AbstractParseNode[kids.length];
            int i = 0;
            while (i < kids.length - 1) {
                rest[i] = kids[i];
                ++i;
            }
            if (newAmbiguities.size() > 1) {
                last = ParseNode.createAmbNode(newAmbiguities.toArray(new AbstractParseNode[newAmbiguities.size()]));
                this.ambiguityManager.increaseAmbiguityCount();
            } else {
                last = (AbstractParseNode)newAmbiguities.get(0);
            }
            rest[rest.length - 1] = last;
            this.ambiguityManager.increaseAmbiguityCount();
            return new ParseNode(t.getLabel(), rest, 2, t.getLine(), t.getColumn(), t.isLayout(), t.isIgnoreLayout(), t.isPlaceholderInsertionNode(), t.isLiteralCompletionNode(), t.isProposal(), t.isNestedProposal(), t.isSinglePlaceholderInsertion());
        }
        if (last.isParseNode()) {
            Label other = this.parseTable.getLabel(((ParseNode)last).getLabel());
            assert (!prodLabel.equals(other));
        }
        return t;
    }

    private Label getProductionLabel(AbstractParseNode t) {
        if (t.isParseNode()) {
            return this.parseTable.getLabel(((ParseNode)t).getLabel());
        }
        if (t instanceof ParseProductionNode) {
            return this.parseTable.getLabel(((ParseProductionNode)t).getLabel());
        }
        return null;
    }

    private AbstractParseNode filterAmbiguities(AbstractParseNode[] ambs, Timer timer) throws FilterException, InterruptedException {
        if (ambs.length == 0) {
            return null;
        }
        AbstractParseNode current = ambs[0];
        int i = 1;
        while (i < ambs.length) {
            current = this.filterAmbiguities(current, ambs[i], timer);
            ++i;
        }
        return current;
    }

    private AbstractParseNode filterAmbiguities(AbstractParseNode amb1, AbstractParseNode amb2, Timer timer) throws FilterException, InterruptedException {
        amb1 = this.filterTree(amb1, timer);
        amb2 = this.filterTree(amb2, timer);
        if (amb1 == null) {
            return amb2;
        }
        if (amb2 == null) {
            return amb1;
        }
        switch (this.filter(amb1, amb2)) {
            case 1: {
                this.ambiguityManager.increaseAmbiguityCount();
                return ParseNode.createAmbNode(amb1, amb2);
            }
            case 2: {
                return amb1;
            }
            case 3: {
                return amb2;
            }
        }
        return null;
    }

    private int filter(AbstractParseNode left, AbstractParseNode right) {
        int r;
        if (left.equals(right)) {
            return 2;
        }
        if (this.filterDirectPreference && this.parseTable.hasPrefersOrAvoids() && (r = this.filterOnIndirectPrefers(left, right)) != 1) {
            return r;
        }
        if (this.filterPreferenceCount && this.parseTable.hasPrefersOrAvoids() && (r = this.filterOnPreferCount(left, right)) != 1) {
            return r;
        }
        if (this.filterInjectionCount && (r = this.filterOnInjectionCount(left, right)) != 1) {
            return r;
        }
        if (this.filterLongestMatch && (r = this.filterLongestMatch(left, right)) != 1) {
            return r;
        }
        return this.filterPermissiveLiterals(left, right);
    }

    private int filterPermissiveLiterals(AbstractParseNode left, AbstractParseNode right) {
        if (left.isParseNode() && right.isParseNode()) {
            AbstractParseNode[] leftKids = ((ParseNode)left).kids;
            AbstractParseNode[] rightKids = ((ParseNode)right).kids;
            if (leftKids.length > 0 && rightKids.length == 1 && leftKids[0].isParseProductionNode() && rightKids[0].equals(left)) {
                return 2;
            }
            if (rightKids.length > 0 && leftKids.length == 1 && rightKids[0].isParseProductionNode() && leftKids[0].equals(right)) {
                return 3;
            }
        }
        return 1;
    }

    private int filterOnInjectionCount(AbstractParseNode left, AbstractParseNode right) {
        this.ambiguityManager.increaseInjectionCount();
        int leftInjectionCount = this.countAllInjections(left);
        int rightInjectionCount = this.countAllInjections(right);
        if (leftInjectionCount != rightInjectionCount) {
            this.ambiguityManager.increaseInjectionFilterSucceededCount();
        }
        if (leftInjectionCount > rightInjectionCount) {
            return 3;
        }
        if (rightInjectionCount > leftInjectionCount) {
            return 2;
        }
        return 1;
    }

    private int countAllInjections(AbstractParseNode t) {
        if (t.isAmbNode()) {
            return t.getChildren().length == 0 ? 0 : this.countAllInjections(t.getChildren()[0]);
        }
        if (t.isParseNode()) {
            int c = this.getProductionLabel(t).isInjection() ? 1 : 0;
            return c + this.countAllInjections(((ParseNode)t).kids);
        }
        return 0;
    }

    private int countAllInjections(AbstractParseNode[] ls) {
        int r = 0;
        int i = 0;
        int max2 = ls.length;
        while (i < max2) {
            r += this.countAllInjections(ls[i]);
            ++i;
        }
        return r;
    }

    private int filterOnPreferCount(AbstractParseNode left, AbstractParseNode right) {
        this.ambiguityManager.increaseEagernessFilterCalledCount();
        int r = 1;
        if (this.parseTable.hasPrefers() || this.parseTable.hasAvoids()) {
            int leftPreferCount = this.countPrefers(left);
            int rightPreferCount = this.countPrefers(right);
            int leftAvoidCount = this.countAvoids(left);
            int rightAvoidCount = this.countAvoids(right);
            if (leftPreferCount > rightPreferCount && leftAvoidCount <= rightAvoidCount || leftPreferCount == rightPreferCount && leftAvoidCount < rightAvoidCount) {
                Tools.logger("Eagerness priority: ", left, " > ", right);
                r = 2;
            }
            if (rightPreferCount > leftPreferCount && rightAvoidCount <= leftAvoidCount || rightPreferCount == leftPreferCount && rightAvoidCount < leftAvoidCount) {
                if (r != 1) {
                    Tools.logger("Symmetric eagerness priority: ", left, " == ", right);
                    r = 1;
                } else {
                    Tools.logger("Eagerness priority: ", right, " > ", left);
                    r = 3;
                }
            }
        }
        if (r != 1) {
            this.ambiguityManager.increaseEagernessFilterSucceededCount();
        }
        return r;
    }

    private int countPrefers(AbstractParseNode t) {
        if (t.isAmbNode()) {
            return this.countPrefers(t.getChildren());
        }
        if (t.isParseNode()) {
            int type = this.getProductionType(t);
            if (type == 2) {
                return 1;
            }
            if (type == 4) {
                return 0;
            }
            return this.countPrefers(((ParseNode)t).kids);
        }
        return 0;
    }

    private int countPrefers(AbstractParseNode[] ls) {
        int r = 0;
        AbstractParseNode[] abstractParseNodeArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode n3 = abstractParseNodeArray[n2];
            r += this.countPrefers(n3);
            ++n2;
        }
        return r;
    }

    private int countAvoids(AbstractParseNode t) {
        if (t.isAmbNode()) {
            return this.countAvoids(t.getChildren());
        }
        if (t.isParseNode()) {
            int type = this.getProductionType(t);
            if (type == 2) {
                return 0;
            }
            if (type == 4) {
                return 1;
            }
            return this.countAvoids(((ParseNode)t).kids);
        }
        return 0;
    }

    private int countAvoids(AbstractParseNode[] ls) {
        int r = 0;
        AbstractParseNode[] abstractParseNodeArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractParseNode n3 = abstractParseNodeArray[n2];
            r += this.countAvoids(n3);
            ++n2;
        }
        return r;
    }

    private int filterOnIndirectPrefers(AbstractParseNode left, AbstractParseNode right) {
        if (left.isAmbNode() || right.isAmbNode()) {
            return 1;
        }
        if (!this.getLabel(left).equals(this.getLabel(right))) {
            return this.filterOnDirectPrefers(left, right);
        }
        ParseNode l = (ParseNode)left;
        ParseNode r = (ParseNode)right;
        AbstractParseNode[] leftArgs = l.kids;
        AbstractParseNode[] rightArgs = r.kids;
        int diffs = this.computeDistinctArguments(leftArgs, rightArgs);
        if (diffs == 1) {
            int i = 0;
            while (i < leftArgs.length) {
                AbstractParseNode leftArg = leftArgs[i];
                AbstractParseNode rightArg = rightArgs[i];
                if (!leftArg.equals(rightArg)) {
                    return this.filterOnIndirectPrefers(leftArg, rightArg);
                }
                ++i;
            }
        }
        return 1;
    }

    private int filterOnDirectPrefers(AbstractParseNode left, AbstractParseNode right) {
        if (this.isLeftMoreEager(left, right)) {
            return 2;
        }
        if (this.isLeftMoreEager(right, left)) {
            return 3;
        }
        return 1;
    }

    private boolean isLeftMoreEager(AbstractParseNode left, AbstractParseNode right) {
        assert (!left.isAmbNode() && !right.isAmbNode());
        if (this.isMoreEager(left, right)) {
            return true;
        }
        AbstractParseNode newLeft = this.jumpOverInjectionsModuloEagerness(left);
        AbstractParseNode newRight = this.jumpOverInjectionsModuloEagerness(right);
        if (newLeft.isParseNode() && newRight.isParseNode()) {
            return this.isMoreEager(newLeft, newRight);
        }
        return false;
    }

    private AbstractParseNode jumpOverInjectionsModuloEagerness(AbstractParseNode t) {
        int prodType = this.getProductionType(t);
        if (t.isParseNode() && prodType != 2 && prodType != 4) {
            Label prod = this.getLabel(t);
            while (prod.isInjection()) {
                int prodTypeX;
                t = ((ParseNode)t).kids[0];
                if (t.isParseNode() && (prodTypeX = this.getProductionType(t)) != 2 && prodTypeX != 4) {
                    prod = this.getLabel(t);
                    continue;
                }
                return t;
            }
        }
        return t;
    }

    private Label getLabel(AbstractParseNode t) {
        if (t.isParseNode()) {
            ParseNode n = (ParseNode)t;
            return this.parseTable.getLabel(n.getLabel());
        }
        if (t instanceof ParseProductionNode) {
            ParseProductionNode n = (ParseProductionNode)t;
            return this.parseTable.getLabel(n.prod);
        }
        return null;
    }

    private int getProductionType(AbstractParseNode t) {
        return this.getLabel(t).getAttributes().getType();
    }

    private boolean isMoreEager(AbstractParseNode left, AbstractParseNode right) {
        Label rightProd;
        int leftLabel = ((ParseNode)left).getLabel();
        int rightLabel = ((ParseNode)right).getLabel();
        Label leftProd = this.parseTable.getLabel(leftLabel);
        return leftProd.isMoreEager(rightProd = this.parseTable.getLabel(rightLabel));
    }

    private int computeDistinctArguments(AbstractParseNode[] leftArgs, AbstractParseNode[] rightArgs) {
        int r = 0;
        int i = 0;
        while (i < leftArgs.length) {
            if (!leftArgs[i].equals(rightArgs[i])) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private boolean isCyclicTerm(AbstractParseNode t) {
        this.ambiguityManager.dumpIndexTable();
        List<AbstractParseNode> cycles = this.computeCyclicTerm(t);
        return cycles != null && cycles.size() > 0;
    }

    private List<AbstractParseNode> computeCyclicTerm(AbstractParseNode t) {
        PositionMap visited = new PositionMap(this.ambiguityManager.getMaxNumberOfAmbiguities());
        this.ambiguityCount += this.ambiguityManager.getAmbiguitiesCount();
        this.ambiguityManager.resetAmbiguityCount();
        return this.computeCyclicTerm(t, false, visited);
    }

    private List<AbstractParseNode> computeCyclicTerm(AbstractParseNode t, boolean inAmbiguityCluster, PositionMap visited) {
        if (t instanceof ParseProductionNode) {
            return null;
        }
        if (t.isParseNode()) {
            List<AbstractParseNode> cycle = null;
            ParseNode n = (ParseNode)t;
            if (!inAmbiguityCluster) {
                throw new NotImplementedException();
            }
            cycle = this.computeCyclicTerm(n.kids, false, visited);
            return cycle;
        }
        throw new FatalException();
    }

    private List<AbstractParseNode> computeCyclicTerm(AbstractParseNode[] kids, boolean b, PositionMap visited) {
        int i = 0;
        int max2 = kids.length;
        while (i < max2) {
            List<AbstractParseNode> cycle = this.computeCyclicTerm(kids[i], false, visited);
            if (cycle != null) {
                return cycle;
            }
            ++i;
        }
        return null;
    }

    private List<int[]> getLongestMatchPositions(AbstractParseNode n) {
        if (n.isAmbNode()) {
            List<int[]> pos1 = this.getLongestMatchPositions(n.getChildren()[0]);
            List<int[]> pos2 = this.getLongestMatchPositions(n.getChildren()[1]);
            assert (pos1.size() == pos2.size());
            return pos1;
        }
        LinkedList<AbstractParseNode> nodes = new LinkedList<AbstractParseNode>();
        nodes.push(n);
        ArrayList<int[]> positions = new ArrayList<int[]>();
        while (!nodes.isEmpty()) {
            n = (AbstractParseNode)nodes.pop();
            if (n.isParseProductionNode()) continue;
            if (!n.isAmbNode() && this.parseTable.getLabel(n.getLabel()).getAttributes().isLongestMatch()) {
                positions.add(new int[]{n.getLine(), n.getColumn(), n.getLast().getLine(), n.getLast().getColumn()});
            }
            int i = n.getChildren().length - 1;
            while (i >= 0) {
                nodes.push(n.getChildren()[i]);
                --i;
            }
        }
        return positions;
    }

    private Iterator<int[]> getLongestMatchIterator(AbstractParseNode n) {
        if (n.isAmbNode()) {
            List<int[]> pos1 = this.getLongestMatchPositions(n.getChildren()[0]);
            List<int[]> pos2 = this.getLongestMatchPositions(n.getChildren()[1]);
            assert (pos1.size() == pos2.size());
            return pos1.iterator();
        }
        return new LongestMatchIterator(n);
    }

    private int filterLongestMatch(AbstractParseNode left, AbstractParseNode right) {
        Iterator<int[]> leftPositions = this.getLongestMatchIterator(left);
        Iterator<int[]> rightPositions = this.getLongestMatchIterator(right);
        while (leftPositions.hasNext() && rightPositions.hasNext()) {
            int[] rightPosition;
            int[] leftPosition = leftPositions.next();
            if (leftPosition[0] == (rightPosition = rightPositions.next())[0] && leftPosition[1] == rightPosition[1]) {
                if (leftPosition[2] > rightPosition[2] || leftPosition[2] == rightPosition[2] && leftPosition[3] > rightPosition[3]) {
                    return 2;
                }
                if (leftPosition[2] >= rightPosition[2] && (leftPosition[2] != rightPosition[2] || leftPosition[3] >= rightPosition[3])) continue;
                return 3;
            }
            System.out.println("mismatching start");
        }
        assert (!leftPositions.hasNext() && !rightPositions.hasNext());
        return 1;
    }

    private class LongestMatchIterator
    implements Iterator<int[]> {
        private int[] next = null;
        private boolean computedNext = false;
        private LinkedList<AbstractParseNode> nodes = new LinkedList();

        public LongestMatchIterator(AbstractParseNode n) {
            this.nodes.push(n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int[] next() {
            if (!this.computedNext) {
                this.computeNext();
            }
            int[] res = this.next;
            this.computedNext = false;
            this.next = null;
            return res;
        }

        @Override
        public boolean hasNext() {
            if (!this.computedNext) {
                this.computeNext();
            }
            return this.next != null;
        }

        private void computeNext() {
            while (!this.computedNext && !this.nodes.isEmpty()) {
                AbstractParseNode n = this.nodes.pop();
                if (n.isParseProductionNode()) continue;
                if (!n.isLayout()) {
                    int i = n.getChildren().length - 1;
                    while (i >= 0) {
                        this.nodes.push(n.getChildren()[i]);
                        --i;
                    }
                }
                if (n.isAmbNode() || !Disambiguator.this.parseTable.getLabel(n.getLabel()).getAttributes().isLongestMatch()) continue;
                this.next = new int[]{n.getLine(), n.getColumn(), n.getLast().getLine(), n.getLast().getColumn()};
                this.computedNext = true;
            }
        }
    }
}

