/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.util;

import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.stratego.CallT;
import org.spoofax.interpreter.stratego.Let;
import org.spoofax.interpreter.stratego.Scope;
import org.spoofax.interpreter.stratego.Strategy;

public class DebugUtil {
    public static boolean debugging = false;
    public static boolean tracing = false;
    public static final int INDENT_STEP = 2;
    private static final char[] indent = new char[2000];

    static {
        int i = 0;
        while (i < indent.length) {
            DebugUtil.indent[i] = 32;
            ++i;
        }
    }

    public static boolean traceReturn(boolean result, Object current, Strategy strategy) {
        if (debugging) {
            String s;
            boolean doIndent = strategy instanceof CallT || strategy instanceof Let || strategy instanceof Scope;
            String string = s = doIndent ? DebugUtil.buildIndent(2).toString() : "";
            if (!result) {
                Context.debug(s, "=> failed: ", current, "\n");
            } else {
                Context.debug(s, "=> succeeded: ", current, "\n");
            }
        }
        return result;
    }

    public static void debug(Object s0) {
        if (!DebugUtil.isDebugging()) {
            return;
        }
        DebugUtil.printIfWithinLimit(s0.toString());
    }

    public static void debug(Object s0, Object s1) {
        if (!DebugUtil.isDebugging()) {
            return;
        }
        StringBuilder toPrint = new StringBuilder();
        DebugUtil.writeObject(s0, toPrint);
        DebugUtil.writeObject(s1, toPrint);
        DebugUtil.printIfWithinLimit(toPrint.toString());
    }

    public static void debug(Object s0, Object s1, Object s2) {
        if (!DebugUtil.isDebugging()) {
            return;
        }
        StringBuilder toPrint = new StringBuilder();
        DebugUtil.writeObject(s0, toPrint);
        DebugUtil.writeObject(s1, toPrint);
        DebugUtil.writeObject(s2, toPrint);
        DebugUtil.printIfWithinLimit(toPrint.toString());
    }

    public static void debug(Object s0, Object s1, Object s2, Object s3) {
        if (!DebugUtil.isDebugging()) {
            return;
        }
        StringBuilder toPrint = new StringBuilder();
        DebugUtil.writeObject(s0, toPrint);
        DebugUtil.writeObject(s1, toPrint);
        DebugUtil.writeObject(s2, toPrint);
        DebugUtil.writeObject(s3, toPrint);
        DebugUtil.printIfWithinLimit(toPrint.toString());
    }

    public static void debug(Object ... strings) {
        if (!DebugUtil.isDebugging()) {
            return;
        }
        StringBuilder toPrint = new StringBuilder();
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            DebugUtil.writeObject(s, toPrint);
            ++n2;
        }
        DebugUtil.printIfWithinLimit(toPrint.toString());
    }

    private static void printIfWithinLimit(String s) {
        if (s.length() >= 20000) {
            return;
        }
        System.out.println(s);
    }

    private static void writeObject(Object obj, StringBuilder sb) {
        if (obj.getClass().isArray()) {
            Object[] ss;
            Object[] objectArray = ss = (Object[])obj;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                sb.append(o);
                ++n2;
            }
        } else {
            sb.append(obj);
        }
    }

    public static void setDebug(boolean b) {
        debugging = b;
    }

    public static void bump() {
        Context.indentation += 2;
    }

    public static void unbump() {
        Context.indentation -= 2;
    }

    public static StringBuilder buildIndent(int indentation) {
        StringBuilder b = new StringBuilder(indentation);
        b.append(indent, 0, indentation);
        return b;
    }

    public static boolean isDebugging() {
        return debugging;
    }

    public static void setTracing(boolean enableTracing) {
        tracing = enableTracing;
    }
}

