/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.stratego.CallT;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class CallDynamic
extends Strategy {
    private final IStrategoTerm sref;
    private final Strategy[] svars;
    private final IStrategoTerm[] tvars;

    public CallDynamic(IStrategoTerm sref, Strategy[] svars, IStrategoTerm[] tvars) {
        this.sref = sref;
        this.svars = svars;
        this.tvars = tvars;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        IStrategoTerm actualSRef;
        CallDynamic.debug("CallDynamic.eval() - ", env.current());
        if (TermUtils.isAppl(this.sref) && Tools.isVar((IStrategoAppl)this.sref, env) && TermUtils.isString(actualSRef = env.lookupVar(TermUtils.toJavaStringAt((IStrategoAppl)this.sref, 0)))) {
            String sname = TermUtils.toJavaString(actualSRef);
            CallT callt = new CallT(sname, this.svars, this.tvars);
            callt.getHook().push(this.getHook().pop());
            return callt.eval(env);
        }
        throw new InterpreterException("Invocation target is invalid (cannot be evaluated): " + this.sref);
    }

    @Override
    public void prettyPrint(StupidFormatter fmt) {
        fmt.append("call-dynamic");
    }
}

