/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.attachments.AbstractTermAttachment;
import org.spoofax.terms.attachments.ParentAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;
import org.spoofax.terms.attachments.VolatileTermAttachmentType;

public class TermMatchAttachment
extends AbstractTermAttachment {
    private IStrategoTerm matchedTrm;
    private static final long serialVersionUID = -3114392265614382463L;
    public static final TermAttachmentType<TermMatchAttachment> TYPE = new VolatileTermAttachmentType<TermMatchAttachment>(TermMatchAttachment.class);

    public TermAttachmentType<TermMatchAttachment> getAttachmentType() {
        return TYPE;
    }

    private TermMatchAttachment(IStrategoTerm matchedTrm) {
        this.matchedTrm = matchedTrm;
    }

    public static boolean tryMatchTerms(IStrategoTerm term1, IStrategoTerm term2) {
        assert (term1 != term2);
        assert (ParentAttachment.getRoot(term1) != ParentAttachment.getRoot(term2) || ParentAttachment.getRoot(term2) == null);
        if (TermMatchAttachment.getMatchedTerm(term1) == term2) {
            return true;
        }
        if (!TermMatchAttachment.hasMatchedTerm(term1) && !TermMatchAttachment.hasMatchedTerm(term2)) {
            term1.putAttachment(new TermMatchAttachment(term2));
            term2.putAttachment(new TermMatchAttachment(term1));
            return true;
        }
        return false;
    }

    public static void unMatchTerm(IStrategoTerm term1) {
        IStrategoTerm match1 = TermMatchAttachment.getMatchedTerm(term1);
        if (match1 != null) {
            match1.removeAttachment(TYPE);
            term1.removeAttachment(TYPE);
            assert (TermMatchAttachment.getTermMatchAttachment(term1) == null);
            assert (TermMatchAttachment.getTermMatchAttachment(match1) == null);
        }
    }

    public static void forceMatchTerms(IStrategoTerm term1, IStrategoTerm term2) {
        if (TermMatchAttachment.getMatchedTerm(term1) != term2) {
            TermMatchAttachment.unMatchTerm(term1);
            TermMatchAttachment.unMatchTerm(term2);
            TermMatchAttachment.tryMatchTerms(term1, term2);
            assert (TermMatchAttachment.getMatchedTerm(term1) == term2);
        }
    }

    public static IStrategoTerm getMatchedTerm(IStrategoTerm term) {
        IStrategoTerm matched;
        TermMatchAttachment tma = TermMatchAttachment.getTermMatchAttachment(term);
        IStrategoTerm iStrategoTerm = matched = tma == null ? null : tma.matchedTrm;
        assert (matched == null || TermMatchAttachment.getTermMatchAttachment((IStrategoTerm)matched).matchedTrm == term) : "error: non-symetric term match";
        assert (term != matched || term == null);
        assert (ParentAttachment.getRoot(term) != ParentAttachment.getRoot(matched) || ParentAttachment.getRoot(term) == null);
        return matched;
    }

    public static boolean hasMatchedTerm(IStrategoTerm term1) {
        return TermMatchAttachment.getMatchedTerm(term1) != null;
    }

    private static TermMatchAttachment getTermMatchAttachment(IStrategoTerm term) {
        if (term == null) {
            return null;
        }
        return term.getAttachment(TYPE);
    }
}

