/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.spoofax.interpreter.library.index.IIndex;
import org.spoofax.interpreter.library.index.IndexCollector;
import org.spoofax.interpreter.library.index.IndexEntry;
import org.spoofax.interpreter.library.index.IndexEntryFactory;
import org.spoofax.interpreter.library.index.IndexParentKeyFactory;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class Index
implements IIndex {
    private final Multimap<IStrategoTerm, IndexEntry> entries = HashMultimap.create();
    private final Multimap<IStrategoTerm, IndexEntry> childs = HashMultimap.create();
    private final Multimap<IStrategoTerm, IndexEntry> entriesPerSource = HashMultimap.create();
    private final IndexEntryFactory entryFactory;
    private final IndexParentKeyFactory parentKeyFactory;
    private final IndexCollector collector;

    public Index(ITermFactory termFactory) {
        this.entryFactory = new IndexEntryFactory(termFactory);
        this.parentKeyFactory = new IndexParentKeyFactory(termFactory);
        this.collector = new IndexCollector(termFactory, this.entryFactory);
    }

    @Override
    public IndexEntryFactory entryFactory() {
        return this.entryFactory;
    }

    @Override
    public void startCollection(IStrategoTerm source) {
        this.collector.start(source, this.getInSource(source));
        this.clearSource(source);
    }

    @Override
    public IndexEntry collect(IStrategoTerm key, IStrategoTerm value) {
        return this.collector.add(key, value);
    }

    @Override
    public IndexEntry collect(IStrategoTerm key) {
        return this.collector.add(key);
    }

    @Override
    public IStrategoTuple stopCollection(IStrategoTerm source) {
        this.addAll(source, this.collector.getAddedEntries());
        return this.collector.stop();
    }

    @Override
    public void add(IndexEntry entry) {
        this.entries.put((Object)entry.key, (Object)entry);
        IStrategoTerm parentKey = this.parentKeyFactory.getParentKey(entry.key);
        if (parentKey != null) {
            this.childs.put((Object)parentKey, (Object)entry);
        }
        this.entriesPerSource.put((Object)entry.source, (Object)entry);
    }

    @Override
    public void addAll(IStrategoTerm source, Iterable<IndexEntry> entriesToAdd) {
        Collection entriesInSource = this.entriesPerSource.get((Object)source);
        for (IndexEntry entry : entriesToAdd) {
            this.entries.put((Object)entry.key, (Object)entry);
            IStrategoTerm parentKey = this.parentKeyFactory.getParentKey(entry.key);
            if (parentKey != null) {
                this.childs.put((Object)parentKey, (Object)entry);
            }
            entriesInSource.add(entry);
        }
    }

    @Override
    public Iterable<IndexEntry> get(IStrategoTerm key) {
        return this.entries.get((Object)key);
    }

    @Override
    public Iterable<IndexEntry> getChilds(IStrategoTerm key) {
        return this.childs.get((Object)key);
    }

    @Override
    public Iterable<IndexEntry> getInSource(IStrategoTerm source) {
        return this.entriesPerSource.get((Object)source);
    }

    @Override
    public Set<IStrategoTerm> getSourcesOf(IStrategoTerm key) {
        HashSet sources = Sets.newHashSet();
        for (IndexEntry entry : this.get(key)) {
            sources.add(entry.source);
        }
        return sources;
    }

    @Override
    public Iterable<IndexEntry> getAll() {
        return this.entries.values();
    }

    @Override
    public void clearSource(IStrategoTerm source) {
        for (IndexEntry entry : this.getInSource(source)) {
            this.entries.remove((Object)entry.key, (Object)entry);
            IStrategoTerm parentKey = this.parentKeyFactory.getParentKey(entry.key);
            if (parentKey == null) continue;
            this.childs.remove((Object)parentKey, (Object)entry);
        }
        this.entriesPerSource.removeAll((Object)source);
    }

    @Override
    public Iterable<IStrategoTerm> getAllSources() {
        return this.entriesPerSource.keySet();
    }

    @Override
    public void recover() {
        this.collector.recover();
    }

    @Override
    public void reset() {
        this.entries.clear();
        this.childs.clear();
        this.entriesPerSource.clear();
        this.collector.reset();
    }
}

