/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.io.IOException;
import java.io.InputStream;
import org.spoofax.interpreter.core.Context;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.StackTracer;
import org.spoofax.interpreter.core.StrategoCoreLoader;
import org.spoofax.interpreter.core.UndefinedStrategyException;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.library.spx.SPXInterpreterLibrary;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.stratego.StupidFormatter;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.io.binary.TermReader;

public class Interpreter {
    protected final Context context;
    protected final StrategoCoreLoader loader;

    public Interpreter() {
        this(new TermFactory());
    }

    public Interpreter(ITermFactory factory) {
        this(factory, factory);
    }

    public Interpreter(ITermFactory termFactory, ITermFactory programFactory) {
        Context.indentation = 0;
        this.context = this.createContext(termFactory, programFactory);
        this.loader = new StrategoCoreLoader(this.context);
        this.context.internalAddOperatorRegistry(new SPXInterpreterLibrary());
    }

    public boolean invoke(String name) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        SDefT def = this.lookupUncifiedSVar(name);
        if (def == null) {
            throw new UndefinedStrategyException("Definition '" + name + "' not found", name);
        }
        return this.evaluate(def);
    }

    public boolean evaluate(IStrategoAppl s) throws InterpreterErrorExit, InterpreterExit, UndefinedStrategyException, InterpreterException {
        ITermFactory factory = this.getFactory();
        IStrategoConstructor sdefT = factory.makeConstructor("SDefT", 4);
        if (s.getConstructor() != sdefT) {
            s = factory.makeAppl(sdefT, factory.makeString("interpreter_evaluate_dummy_0_0"), factory.makeList(), factory.makeList(), s);
        }
        SDefT def = this.loader.parseSDefT(s);
        return this.evaluate(def);
    }

    private boolean evaluate(SDefT def) throws InterpreterException {
        StackTracer stackTracer = this.getContext().getStackTracer();
        stackTracer.push(def.getName());
        try {
            boolean success = def.getBody().evaluate(this.context);
            if (success) {
                stackTracer.popOnSuccess();
            } else {
                stackTracer.popOnFailure();
            }
            return success;
        }
        catch (RuntimeException | InterpreterException e) {
            stackTracer.popOnExit(false);
            throw new InterpreterException("Exception during evaluation: " + e.getMessage(), e);
        }
    }

    public SDefT lookupUncifiedSVar(String name) {
        try {
            SDefT def = this.context.lookupSVar(String.valueOf(Interpreter.cify(name)) + "_0_0");
            if (def == null) {
                def = this.context.lookupSVar(name);
            }
            return def;
        }
        catch (InterpreterException e) {
            throw new RuntimeException(e);
        }
    }

    public static String cify(String input) {
        return input.replace("_", "__").replace("-", "_").replace("'", "_p_").replace("\"", "_q_").replace("\\", "_b_");
    }

    public IContext getContext() {
        return this.context;
    }

    protected Context createContext(ITermFactory termFactory, ITermFactory programFactory) {
        return new Context(termFactory, programFactory);
    }

    public void setCurrent(IStrategoTerm inp) {
        this.context.setCurrent(inp);
    }

    public IStrategoTerm current() {
        return this.context.current();
    }

    public IOAgent getIOAgent() {
        SSLLibrary op = (SSLLibrary)this.getContext().getOperatorRegistry("SSL");
        return op.getIOAgent();
    }

    public void setIOAgent(IOAgent ioAgent) {
        SSLLibrary op = (SSLLibrary)this.getContext().getOperatorRegistry("SSL");
        op.setIOAgent(ioAgent);
        this.getContext().getStackTracer().setIOAgent(ioAgent);
    }

    public void reset() {
        SSLLibrary op = (SSLLibrary)this.getContext().getOperatorRegistry("SSL");
        op.init();
    }

    public String prettyPrint() {
        StupidFormatter sf = new StupidFormatter();
        SDefT s = null;
        try {
            s = this.context.lookupSVar("main_0_0");
        }
        catch (InterpreterException e) {
            throw new RuntimeException(e);
        }
        s.prettyPrint(sf);
        return sf.toString();
    }

    public void shutdown() {
    }

    public ITermFactory getFactory() {
        return this.context.getFactory();
    }

    public ITermFactory getProgramFactory() {
        return this.context.getProgramFactory();
    }

    public final void load(InputStream stream) throws IOException, InterpreterException {
        if (stream == null) {
            throw new IOException("Could not load Stratego core input from null stream");
        }
        this.load(new TermReader(this.context.getProgramFactory()).parseFromStream(stream));
    }

    public final void load(String file) throws IOException, InterpreterException {
        this.load(new TermReader(this.context.getProgramFactory()).parseFromFile(file));
    }

    public void load(IStrategoTerm term) throws InterpreterException {
        this.loader.load(term);
    }

    public void addOperatorRegistry(IOperatorRegistry or) {
        this.context.addOperatorRegistry(or);
    }
}

