/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.resource;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.resource.AntPattern;
import org.metaborg.util.resource.FileSelectorUtils;

public class AntPatternFileSelector
implements FileSelector {
    private static final FileType DEFAULT_FILETYPE = FileType.FILE;
    private final Set<AntPattern> patterns = Sets.newHashSet();
    private final FileType fileType;

    public AntPatternFileSelector(String pattern) {
        this(Iterables2.singleton(pattern), DEFAULT_FILETYPE);
    }

    public AntPatternFileSelector(String pattern, FileType fileType) {
        this(Iterables2.singleton(pattern), fileType);
    }

    public AntPatternFileSelector(Iterable<String> patterns) {
        this(patterns, DEFAULT_FILETYPE);
    }

    public AntPatternFileSelector(Iterable<String> patterns, FileType fileType) {
        for (String pattern : patterns) {
            this.patterns.add(new AntPattern(pattern));
        }
        this.fileType = fileType;
    }

    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        if (FileSelectorUtils.typeMatches(fileInfo.getFile().getType(), this.fileType)) {
            String relativePath = fileInfo.getBaseFolder().getName().getRelativeName(fileInfo.getFile().getName());
            for (AntPattern pattern : this.patterns) {
                if (!pattern.match(relativePath)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return true;
    }
}

