/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.log;

import javax.annotation.Nullable;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;

public abstract class AbstractLogger
implements ILogger {
    protected AbstractLogger() {
    }

    @Override
    public void trace(String msg) {
        this.trace(msg, null);
    }

    @Override
    public abstract void trace(String var1, @Nullable Throwable var2);

    @Override
    public void trace(String format, Object ... args) {
        if (this.traceEnabled()) {
            String msg = this.format(format, args);
            this.trace(msg);
        }
    }

    @Override
    public void trace(String format, Throwable cause, Object ... args) {
        if (this.traceEnabled()) {
            String msg = this.format(format, args);
            this.trace(msg, cause);
        }
    }

    @Override
    public abstract boolean traceEnabled();

    @Override
    public void debug(String msg) {
        this.debug(msg, null);
    }

    @Override
    public abstract void debug(String var1, @Nullable Throwable var2);

    @Override
    public void debug(String format, Object ... args) {
        if (this.debugEnabled()) {
            String msg = this.format(format, args);
            this.debug(msg);
        }
    }

    @Override
    public void debug(String format, Throwable cause, Object ... args) {
        if (this.debugEnabled()) {
            String msg = this.format(format, args);
            this.debug(msg, cause);
        }
    }

    @Override
    public abstract boolean debugEnabled();

    @Override
    public void info(String msg) {
        this.info(msg, null);
    }

    @Override
    public abstract void info(String var1, @Nullable Throwable var2);

    @Override
    public void info(String format, Object ... args) {
        if (this.infoEnabled()) {
            String msg = this.format(format, args);
            this.info(msg);
        }
    }

    @Override
    public void info(String format, Throwable cause, Object ... args) {
        if (this.infoEnabled()) {
            String msg = this.format(format, args);
            this.info(msg, cause);
        }
    }

    @Override
    public abstract boolean infoEnabled();

    @Override
    public void warn(String msg) {
        this.warn(msg, null);
    }

    @Override
    public abstract void warn(String var1, @Nullable Throwable var2);

    @Override
    public void warn(String format, Object ... args) {
        if (this.warnEnabled()) {
            String msg = this.format(format, args);
            this.warn(msg);
        }
    }

    @Override
    public void warn(String format, Throwable cause, Object ... args) {
        if (this.warnEnabled()) {
            String msg = this.format(format, args);
            this.warn(msg, cause);
        }
    }

    @Override
    public abstract boolean warnEnabled();

    @Override
    public void error(String msg) {
        this.error(msg, null);
    }

    @Override
    public abstract void error(String var1, @Nullable Throwable var2);

    @Override
    public void error(String format, Object ... args) {
        if (this.errorEnabled()) {
            String msg = this.format(format, args);
            this.error(msg);
        }
    }

    @Override
    public void error(String format, Throwable cause, Object ... args) {
        if (this.errorEnabled()) {
            String msg = this.format(format, args);
            this.error(msg, cause);
        }
    }

    @Override
    public abstract boolean errorEnabled();

    @Override
    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    @Override
    public void log(Level level, String msg, @Nullable Throwable cause) {
        switch (level) {
            case Trace: {
                this.trace(msg, cause);
                break;
            }
            case Debug: {
                this.debug(msg, cause);
                break;
            }
            case Info: {
                this.info(msg, cause);
                break;
            }
            case Warn: {
                this.warn(msg, cause);
                break;
            }
            case Error: {
                this.error(msg, cause);
                break;
            }
            default: {
                throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized.");
            }
        }
    }

    @Override
    public void log(Level level, String format, Object ... args) {
        if (this.enabled(level)) {
            String msg = this.format(format, args);
            this.log(level, msg);
        }
    }

    @Override
    public void log(Level level, String format, Throwable cause, Object ... args) {
        if (this.enabled(level)) {
            String msg = this.format(format, args);
            this.log(level, msg, cause);
        }
    }

    @Override
    public boolean enabled(Level level) {
        switch (level) {
            case Trace: {
                return this.traceEnabled();
            }
            case Debug: {
                return this.debugEnabled();
            }
            case Info: {
                return this.infoEnabled();
            }
            case Warn: {
                return this.warnEnabled();
            }
            case Error: {
                return this.errorEnabled();
            }
        }
        throw new IllegalStateException("Level " + (Object)((Object)level) + " is not recognized.");
    }

    @Override
    public abstract String format(String var1, Object ... var2);
}

