/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.cmd;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.metaborg.util.cmd.StringUtils;

public class Arguments
implements Iterable<Object>,
Serializable {
    private static final long serialVersionUID = -5031843820289891138L;
    private static final Pattern spaces = Pattern.compile("[\\s]");
    private final Collection<Object> arguments;

    public Arguments() {
        this.arguments = Lists.newLinkedList();
    }

    public Arguments(Arguments other) {
        this.arguments = Lists.newLinkedList(other.arguments);
    }

    public Arguments add(Object arg) {
        if (arg == null || arg instanceof String && ((String)arg).isEmpty()) {
            return this;
        }
        this.arguments.add(arg);
        return this;
    }

    public Arguments add(Object arg0, Object arg1) {
        this.add(arg0);
        this.add(arg1);
        return this;
    }

    public Arguments add(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            this.add(arg);
            ++n2;
        }
        return this;
    }

    public Arguments addLine(String line) {
        this.add(spaces.split(line));
        return this;
    }

    public Arguments addFile(File file) {
        this.add((Object)file);
        return this;
    }

    public Arguments addFile(String flag, File file) {
        this.add((Object)flag);
        this.addFile(file);
        return this;
    }

    public Arguments addFiles(File ... files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.addFile(file);
            ++n2;
        }
        return this;
    }

    public Arguments addAll(Arguments args) {
        this.addAll(args.arguments);
        return this;
    }

    public Arguments addAll(Iterable<Object> args) {
        for (Object obj : args) {
            this.add(obj);
        }
        return this;
    }

    public Arguments clear() {
        this.arguments.clear();
        return this;
    }

    public List<String> asStrings(@Nullable Path workingDirectory) {
        ArrayList<String> result = new ArrayList<String>(this.size());
        for (Object arg : this) {
            result.add(this.asString(arg, workingDirectory));
        }
        return result;
    }

    private String asString(Object arg, @Nullable Path workingDirectory) {
        if (arg instanceof File) {
            Path path = ((File)arg).toPath();
            if (workingDirectory != null) {
                path = workingDirectory.relativize(path);
            }
            return StringUtils.fixFileSeparatorChar(path.toString());
        }
        return arg.toString();
    }

    public int size() {
        return this.arguments.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.arguments.iterator();
    }

    public String toString() {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String arg : this.asStrings(null)) {
            if (!first) {
                sb.append(' ');
            }
            sb.append(StringUtils.quoteArgument(arg));
            first = false;
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Arguments other = (Arguments)obj;
        return this.arguments.equals(other.arguments);
    }
}

