/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive.statix;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import mb.flowspec.terms.B;
import mb.statix.spoofax.SolverMode;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.config.StatixSolverMode;
import org.metaborg.core.context.IContext;
import org.metaborg.spoofax.core.analysis.AnalysisFacet;
import org.metaborg.spoofax.core.config.ISpoofaxProjectConfig;
import org.metaborg.spoofax.core.config.ISpoofaxProjectConfigService;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class STX_solver_mode
extends ASpoofaxContextPrimitive {
    final ISpoofaxProjectConfigService projectConfigService;

    @Inject
    public STX_solver_mode(ISpoofaxProjectConfigService projectConfigService) {
        super(STX_solver_mode.class.getSimpleName(), 0, 0);
        this.projectConfigService = projectConfigService;
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext context) throws MetaborgException, IOException {
        ISpoofaxProjectConfig config = this.projectConfigService.get(context.project());
        if (config != null) {
            String languageName = context.language().belongsTo().name();
            Map<String, SolverMode> modes = config.statixConfig().languageModes(Collections.emptyMap());
            if (modes.containsKey(languageName)) {
                return B.blob((Object)modes.get(languageName));
            }
        }
        return B.blob((Object)this.getSolverMode(context.language().components().stream().filter(lc -> lc.hasFacet(AnalysisFacet.class) && lc.config().statixSolverMode() != null).findAny().map(lc -> lc.config().statixSolverMode()).orElse(StatixSolverMode.traditional)));
    }

    private SolverMode getSolverMode(StatixSolverMode mode) throws MetaborgException {
        switch (mode) {
            case traditional: {
                return SolverMode.TRADITIONAL;
            }
            case concurrent: {
                return SolverMode.CONCURRENT;
            }
            case incremental: {
                return SolverMode.INCREMENTAL;
            }
        }
        throw new MetaborgException("Cannot get solver mode for configuration option " + (Object)((Object)mode));
    }
}

