/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.stratego.primitive;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.build.dependency.MissingDependencyException;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.spoofax.core.stratego.primitive.generic.ASpoofaxContextPrimitive;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.io.binary.TermReader;
import org.spoofax.terms.util.TermUtils;

public abstract class AResourcesPrimitive
extends ASpoofaxContextPrimitive
implements AutoCloseable {
    private static final ILogger log = LoggerUtils.logger(AResourcesPrimitive.class);
    private final IResourceService resourceService;
    private final Cache<FileObject, Tuple2<Long, IStrategoTerm>> fileCache;

    public AResourcesPrimitive(String name, IResourceService resourceService) {
        super(name, 2, 0);
        this.resourceService = resourceService;
        this.fileCache = CacheBuilder.newBuilder().maximumSize(32L).build();
    }

    @Override
    public void close() {
        this.fileCache.invalidateAll();
        this.fileCache.cleanUp();
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, org.metaborg.core.context.IContext context) throws MetaborgException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected IStrategoTerm call(IStrategoTerm current, Strategy[] svars, IStrategoTerm[] tvars, ITermFactory factory, IContext strategoContext) throws MetaborgException, IOException {
        org.metaborg.core.context.IContext context = this.metaborgContext(strategoContext);
        if (context == null) {
            throw new MetaborgException("Cannot execute primitive " + this.name + ", no Spoofax context was set");
        }
        ITermFactory TF = strategoContext.getFactory();
        Strategy nameToPathStr = svars[0];
        Strategy importStr = svars[1];
        TermReader termReader = new TermReader(TF);
        List<FileObject> locations = this.locations(context);
        LinkedList names = Lists.newLinkedList(this.parseNames(current));
        HashMap resources = Maps.newHashMap();
        while (!names.isEmpty()) {
            IStrategoTerm name = (IStrategoTerm)names.pop();
            if (resources.containsKey(name)) continue;
            String path = this.resourcePath(strategoContext, nameToPathStr, name);
            IStrategoTerm resource = this.loadResource(locations, path, termReader).orElse(null);
            if (resource == null) {
                return null;
            }
            resources.put(name, resource);
            names.addAll(this.resourceImports(strategoContext, importStr, resource));
        }
        return TF.makeList(resources.entrySet().stream().map(e -> TF.makeTuple((IStrategoTerm)e.getKey(), (IStrategoTerm)e.getValue())).collect(Collectors.toList()));
    }

    protected abstract List<FileObject> locations(org.metaborg.core.context.IContext var1) throws MissingDependencyException;

    private Optional<IStrategoTerm> loadResource(List<FileObject> locations, String path, TermReader termReader) {
        for (FileObject location : locations) {
            IStrategoTerm term;
            FileObject file;
            try {
                file = this.resourceService.resolve(location, path);
            }
            catch (MetaborgRuntimeException e) {
                continue;
            }
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (FileContent content = file.getContent();){
                    Tuple2 cacheEntry = (Tuple2)this.fileCache.getIfPresent((Object)file);
                    if (cacheEntry != null && (Long)cacheEntry._1() >= content.getLastModifiedTime()) {
                        term = (IStrategoTerm)cacheEntry._2();
                    } else {
                        term = termReader.parseFromStream(content.getInputStream());
                        this.fileCache.put((Object)file, Tuple2.of(content.getLastModifiedTime(), term));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.fileCache.invalidateAll(Arrays.asList(file));
                continue;
            }
            return Optional.of(term);
        }
        log.error("Could not find {}", path);
        return Optional.empty();
    }

    private String resourcePath(IContext strategoContext, Strategy s, IStrategoTerm name) throws MetaborgException {
        strategoContext.setCurrent(name);
        try {
            if (!s.evaluate(strategoContext)) {
                throw new MetaborgException("Strategy failed to get path for name " + name);
            }
        }
        catch (InterpreterException e) {
            throw new MetaborgException(e);
        }
        IStrategoTerm current = strategoContext.current();
        if (!TermUtils.isString(current)) {
            throw new MetaborgException("Expected path string, got " + current);
        }
        return TermUtils.toJavaString(current);
    }

    private List<IStrategoTerm> resourceImports(IContext strategoContext, Strategy s, IStrategoTerm resource) throws MetaborgException {
        strategoContext.setCurrent(resource);
        try {
            if (!s.evaluate(strategoContext)) {
                return Collections.emptyList();
            }
        }
        catch (InterpreterException e) {
            throw new MetaborgException(e);
        }
        return this.parseNames(strategoContext.current());
    }

    private List<IStrategoTerm> parseNames(IStrategoTerm current) throws MetaborgException {
        if (!TermUtils.isList(current)) {
            throw new MetaborgException("Expected list of names, got " + current);
        }
        return Lists.newArrayList((Object[])current.getAllSubterms());
    }
}

