/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.engine;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.metaborg.runtime.task.BaseTaskFactory;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.ITaskFactory;
import org.metaborg.runtime.task.TaskStorageType;
import org.metaborg.runtime.task.TaskType;
import org.metaborg.runtime.task.digest.ITermDigester;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.engine.TaskCollection;
import org.metaborg.runtime.task.evaluation.ITaskEvaluationFrontend;
import org.metaborg.runtime.task.util.TermTools;
import org.metaborg.util.collection.BiLinkedHashMultimap;
import org.metaborg.util.collection.BiSetMultimap;
import org.metaborg.util.collection.UniqueQueue;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;

public class TaskEngine
implements ITaskEngine {
    private final ITermFactory factory;
    private final ITermDigester digester;
    private ITaskEvaluationFrontend evaluationFrontend;
    private final ITaskFactory baseTaskFactory;
    private final IStrategoConstructor resultConstructor;
    private final Map<IStrategoConstructor, ITaskFactory> taskFactories = Maps.newHashMap();
    private final BiMap<IStrategoTerm, ITask> toTask = HashBiMap.create();
    private final Table<IStrategoAppl, IStrategoList, IStrategoTerm> toTaskID = HashBasedTable.create();
    private final BiSetMultimap<IStrategoTerm, IStrategoTerm> toSource = BiLinkedHashMultimap.create();
    private final BiSetMultimap<IStrategoTerm, IStrategoTerm> toDependency = BiLinkedHashMultimap.create();
    private final BiSetMultimap<IStrategoTerm, IStrategoTerm> toDynamicDependency = BiLinkedHashMultimap.create();
    private final BiSetMultimap<IStrategoTerm, IStrategoTerm> toRead = BiLinkedHashMultimap.create();
    private final Queue<IStrategoTerm> garbage = new UniqueQueue<IStrategoTerm>();
    private final Set<IStrategoTerm> scheduled = Sets.newHashSet();
    private final TaskCollection taskCollection;

    public TaskEngine(ITermFactory factory, ITermDigester digester) {
        this.factory = factory;
        this.digester = digester;
        this.taskCollection = new TaskCollection();
        this.baseTaskFactory = new BaseTaskFactory(factory, this);
        this.resultConstructor = factory.makeConstructor("Result", 1);
    }

    @Override
    public ITermDigester getDigester() {
        return this.digester;
    }

    @Override
    public ITaskEvaluationFrontend getEvaluationFrontend() {
        return this.evaluationFrontend;
    }

    @Override
    public void setEvaluationFrontend(ITaskEvaluationFrontend evaluationFrontend) {
        this.evaluationFrontend = evaluationFrontend;
    }

    @Override
    public ITaskFactory getTaskFactory(IStrategoAppl instruction) {
        ITaskFactory taskFactory = this.taskFactories.get(instruction.getConstructor());
        if (taskFactory == null) {
            return this.baseTaskFactory;
        }
        return taskFactory;
    }

    @Override
    public void registerTaskFactory(IStrategoConstructor constructor, ITaskFactory factory) {
        this.taskFactories.put(constructor, factory);
    }

    @Override
    public void startCollection(IStrategoTerm source) {
        this.taskCollection.startCollection(source, this.getFromSource(source));
    }

    @Override
    public IStrategoTerm createTaskID(IStrategoAppl instruction, IStrategoList dependencies) {
        IStrategoTerm taskID = this.getTaskID(instruction, dependencies);
        if (taskID != null) {
            return taskID;
        }
        taskID = this.digester.digest(this.factory, instruction, dependencies);
        this.toTaskID.put((Object)instruction, (Object)dependencies, (Object)taskID);
        ITask task = this.getTask(taskID);
        if (task == null) {
            return taskID;
        }
        IStrategoAppl instr = task.initialInstruction();
        if (!instruction.match(instr)) {
            this.reset();
            throw new IllegalStateException("Identifier collision, task " + instruction + " and " + instr + " have the same identifier: " + taskID);
        }
        return taskID;
    }

    @Override
    public IStrategoTerm addTask(IStrategoTerm source, IStrategoList dependencies, IStrategoAppl instruction, TaskType type, TaskStorageType storageType, boolean shortCircuit) {
        if (!this.taskCollection.inCollection(source)) {
            throw new IllegalStateException("Collection has not been started yet. Call task-start-collection(|partition) before adding tasks.");
        }
        ITaskFactory taskFactory = this.getTaskFactory(instruction);
        dependencies = taskFactory.adjustDependencies(dependencies);
        IStrategoTerm taskID = this.createTaskID(instruction, dependencies);
        if (this.getTask(taskID) == null) {
            ITask task = taskFactory.create(instruction, dependencies, type, storageType, storageType, shortCircuit);
            this.toTask.put((Object)taskID, (Object)task);
            this.taskCollection.addTask(taskID);
            this.schedule(taskID);
        }
        this.taskCollection.keepTask(taskID);
        this.addToSource(taskID, source);
        for (IStrategoTerm dependency : dependencies) {
            this.addDependency(taskID, dependency);
        }
        return this.createResult(taskID);
    }

    private IStrategoAppl createResult(IStrategoTerm taskID) {
        return this.factory.makeAppl(this.resultConstructor, taskID);
    }

    @Override
    public void addPersistedTask(IStrategoTerm taskID, ITask task, IStrategoList initialDependencies) {
        if (this.getTask(taskID) != null) {
            throw new RuntimeException("Trying to add a persisted task that already exists.");
        }
        this.toTask.put((Object)taskID, (Object)task);
        this.toTaskID.put((Object)task.initialInstruction(), (Object)initialDependencies, (Object)taskID);
    }

    @Override
    public void removeTask(IStrategoTerm taskID) {
        this.trashUnreferencedTasks(Lists.newArrayList(this.getFromSource(taskID)), taskID);
        this.removeSourcesOf(taskID);
        this.removeDependencies(taskID);
        this.removeReads(taskID);
        this.scheduled.remove(taskID);
        ITask task = this.getTask(taskID);
        if (task == null) {
            return;
        }
        this.toTaskID.remove((Object)task.initialInstruction(), (Object)TermTools.makeList(this.factory, task.initialDependencies()));
        this.toTask.remove((Object)taskID);
    }

    @Override
    public IStrategoTerm stopCollection(IStrategoTerm source) {
        Iterable<IStrategoTerm> removedTasks = this.taskCollection.stopCollection(source);
        Iterable<IStrategoTerm> addedTasks = this.taskCollection.addedTasks();
        this.trashUnreferencedTasks(removedTasks, source);
        this.collectGarbage();
        return this.factory.makeTuple(TermTools.makeList(this.factory, removedTasks), TermTools.makeList(this.factory, addedTasks));
    }

    private void trashUnreferencedTasks(Iterable<IStrategoTerm> taskIDs, IStrategoTerm source) {
        for (IStrategoTerm removed : taskIDs) {
            this.removeFromSource(removed, source);
            if (!this.getSourcesOf(removed).isEmpty()) continue;
            this.garbage.add(removed);
        }
    }

    private void collectGarbage() {
        IStrategoTerm taskID;
        while ((taskID = this.garbage.poll()) != null) {
            this.removeTask(taskID);
        }
    }

    private void schedule(IStrategoTerm taskID) {
        this.scheduled.add(taskID);
    }

    @Override
    public ITask invalidate(IStrategoTerm taskID) {
        ITask task = this.getTask(taskID);
        if (task == null) {
            task = this.getTask(taskID);
            if (task == null) {
                throw new RuntimeException("Cannot invalidate task that does not exist: " + taskID);
            }
            ITaskFactory taskFactory = this.getTaskFactory(task.initialInstruction());
            task = taskFactory.clone(task);
            this.toTask.put((Object)taskID, (Object)task);
        }
        task.unsolve();
        task.clearMessage();
        this.removeReads(taskID);
        return task;
    }

    @Override
    public Set<IStrategoTerm> invalidateTaskReads(IStrategoList changedReads) {
        IStrategoTerm taskID;
        HashSet seen = Sets.newHashSet();
        LinkedList workList = Lists.newLinkedList();
        for (IStrategoTerm changedRead : changedReads) {
            Iterables.addAll((Collection)seen, this.getReaders(changedRead));
        }
        workList.addAll(seen);
        while ((taskID = (IStrategoTerm)workList.poll()) != null) {
            this.schedule(taskID);
            Iterable<IStrategoTerm> dependent = this.getDependents(taskID, true);
            for (IStrategoTerm dependentTaskID : dependent) {
                if (!seen.add(dependentTaskID)) continue;
                workList.offer(dependentTaskID);
            }
        }
        return seen;
    }

    @Override
    public IStrategoTerm evaluateScheduled(IContext context, Strategy collect, Strategy insert, Strategy perform) {
        for (IStrategoTerm taskID : this.scheduled) {
            ITask task = this.invalidate(taskID);
            task.clearInstructionOverride();
        }
        this.clearTimes();
        this.clearEvaluations();
        IStrategoTuple result = this.evaluationFrontend.evaluate(this.scheduled, context, collect, insert, perform);
        this.scheduled.clear();
        return result;
    }

    @Override
    public IStrategoTerm evaluateNow(IContext context, Strategy collect, Strategy insert, Strategy perform, Iterable<IStrategoTerm> taskIDs) {
        HashSet scheduled = Sets.newHashSet(taskIDs);
        for (IStrategoTerm taskID : taskIDs) {
            scheduled.addAll(this.getTransitiveDependencies(taskID));
        }
        return this.evaluationFrontend.evaluate(scheduled, context, collect, insert, perform);
    }

    @Override
    public ITask getTask(IStrategoTerm taskID) {
        return (ITask)this.toTask.get((Object)taskID);
    }

    @Override
    public IStrategoTerm getTaskID(ITask task) {
        return (IStrategoTerm)this.toTask.inverse().get((Object)task);
    }

    @Override
    public IStrategoTerm getTaskID(IStrategoAppl instruction, IStrategoList dependencies) {
        return (IStrategoTerm)this.toTaskID.get((Object)instruction, (Object)dependencies);
    }

    @Override
    public Iterable<IStrategoTerm> getTaskIDs() {
        return this.toTask.keySet();
    }

    @Override
    public Iterable<ITask> getTasks() {
        return this.toTask.values();
    }

    @Override
    public Iterable<Map.Entry<IStrategoTerm, ITask>> getTaskEntries() {
        return this.toTask.entrySet();
    }

    @Override
    public Set<IStrategoTerm> getAllSources() {
        return Sets.newHashSet((Iterable)this.toSource.values());
    }

    @Override
    public Set<IStrategoTerm> getSourcesOf(IStrategoTerm taskID) {
        return this.toSource.get(taskID);
    }

    @Override
    public Iterable<IStrategoTerm> getFromSource(IStrategoTerm source) {
        return this.toSource.getInverse((Object)source);
    }

    @Override
    public void addToSource(IStrategoTerm taskID, IStrategoTerm source) {
        this.toSource.put(taskID, source);
    }

    @Override
    public void removeFromSource(IStrategoTerm taskID, IStrategoTerm source) {
        this.toSource.remove(taskID, source);
    }

    @Override
    public void removeSourcesOf(IStrategoTerm taskID) {
        this.toSource.removeAll(taskID);
    }

    @Override
    public Iterable<IStrategoTerm> getDependencies(IStrategoTerm taskID, boolean withDynamic) {
        if (withDynamic) {
            return Sets.union((Set)this.toDynamicDependency.get(taskID), (Set)this.toDependency.get(taskID));
        }
        return this.toDependency.get(taskID);
    }

    @Override
    public Iterable<IStrategoTerm> getDynamicDependencies(IStrategoTerm taskID) {
        return this.toDynamicDependency.get(taskID);
    }

    @Override
    public Set<IStrategoTerm> getTransitiveDependencies(IStrategoTerm taskID) {
        IStrategoTerm queueTaskID;
        HashSet seen = Sets.newHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(taskID);
        seen.add(taskID);
        while ((queueTaskID = (IStrategoTerm)queue.poll()) != null) {
            for (IStrategoTerm dependency : this.getDependencies(queueTaskID, false)) {
                if (!seen.add(dependency)) continue;
                queue.add(dependency);
            }
        }
        seen.remove(taskID);
        return seen;
    }

    @Override
    public Iterable<IStrategoTerm> getDependents(IStrategoTerm taskID, boolean withDynamic) {
        if (withDynamic) {
            return Sets.union((Set)this.toDynamicDependency.getInverse((Object)taskID), (Set)this.toDependency.getInverse((Object)taskID));
        }
        return this.toDependency.getInverse((Object)taskID);
    }

    @Override
    public Iterable<IStrategoTerm> getDynamicDependents(IStrategoTerm taskID) {
        return this.toDynamicDependency.getInverse((Object)taskID);
    }

    @Override
    public boolean becomesCyclic(IStrategoTerm taskIDFrom, IStrategoTerm taskIDTo) {
        IStrategoTerm taskID;
        HashSet seen = Sets.newHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(taskIDTo);
        seen.add(taskIDTo);
        while ((taskID = (IStrategoTerm)queue.poll()) != null) {
            for (IStrategoTerm dependency : this.getDependencies(taskID, false)) {
                if (dependency.equals(taskIDFrom)) {
                    return true;
                }
                if (!seen.add(dependency)) continue;
                queue.add(dependency);
            }
        }
        return false;
    }

    @Override
    public void addDependency(IStrategoTerm taskID, IStrategoTerm dependency) {
        this.toDependency.put(taskID, dependency);
    }

    @Override
    public void setDynamicDependencies(IStrategoTerm taskID, Iterable<IStrategoTerm> dependencies) {
        this.toDynamicDependency.removeAll(taskID);
        this.toDynamicDependency.putAll(taskID, dependencies);
    }

    @Override
    public void removeDependencies(IStrategoTerm taskID) {
        this.toDependency.removeAll(taskID);
        this.toDependency.removeAllInverse(taskID);
        this.toDynamicDependency.removeAll(taskID);
        this.toDynamicDependency.removeAllInverse(taskID);
    }

    @Override
    public Iterable<IStrategoTerm> getReads(IStrategoTerm taskID) {
        return this.toRead.get(taskID);
    }

    @Override
    public Iterable<IStrategoTerm> getReaders(IStrategoTerm uri) {
        return this.toRead.getInverse((Object)uri);
    }

    @Override
    public void addRead(IStrategoTerm taskID, IStrategoTerm uri) {
        this.toRead.put(taskID, uri);
    }

    @Override
    public void removeReads(IStrategoTerm taskID) {
        this.toRead.removeAll(taskID);
    }

    @Override
    public void clearTimes() {
        for (ITask task : this.getTasks()) {
            task.clearTime();
        }
    }

    @Override
    public void clearEvaluations() {
        for (ITask task : this.getTasks()) {
            task.clearEvaluations();
        }
    }

    @Override
    public void recover() {
        this.evaluationFrontend.reset();
        this.taskCollection.recover();
    }

    @Override
    public void reset() {
        this.digester.reset();
        this.evaluationFrontend.reset();
        this.taskCollection.reset();
        this.toTask.clear();
        this.toTaskID.clear();
        this.toSource.clear();
        this.toDependency.clear();
        this.toDynamicDependency.clear();
        this.toRead.clear();
        this.garbage.clear();
        this.scheduled.clear();
    }
}

