/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.symbols;

import java.util.ArrayList;
import org.metaborg.parsetable.ParseTableReadException;
import org.metaborg.parsetable.characterclasses.CharacterClassReader;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.metaborg.parsetable.symbols.AltSymbol;
import org.metaborg.parsetable.symbols.IMetaVarSymbol;
import org.metaborg.parsetable.symbols.INonTerminalSymbol;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.parsetable.symbols.ITerminalSymbol;
import org.metaborg.parsetable.symbols.LayoutSymbol;
import org.metaborg.parsetable.symbols.LiteralSymbol;
import org.metaborg.parsetable.symbols.MetaVarCardinality;
import org.metaborg.parsetable.symbols.MetaVarSymbol;
import org.metaborg.parsetable.symbols.ParameterizedSortSymbol;
import org.metaborg.parsetable.symbols.SequenceSymbol;
import org.metaborg.parsetable.symbols.SortCardinality;
import org.metaborg.parsetable.symbols.SortSymbol;
import org.metaborg.parsetable.symbols.SyntaxContext;
import org.metaborg.parsetable.symbols.TerminalSymbol;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class SymbolReader {
    private final CharacterClassReader characterClassReader;

    public SymbolReader(CharacterClassReader characterClassReader) {
        this.characterClassReader = characterClassReader;
    }

    public ISymbol read(IStrategoAppl symbolTerm) throws ParseTableReadException {
        SortCardinality cardinality;
        IStrategoAppl symbolTermUnpacked = symbolTerm;
        if ("varsym".equals(TermUtils.asAppl(symbolTermUnpacked).map(s -> s.getConstructor().getName()).orElse(null))) {
            return this.readMetaVar(TermUtils.toApplAt(symbolTermUnpacked, 0));
        }
        SyntaxContext syntaxContext = this.getSyntaxContext(symbolTermUnpacked);
        if (syntaxContext != null) {
            symbolTermUnpacked = TermUtils.toApplAt(symbolTermUnpacked, 0);
        }
        if ((cardinality = this.getSortCardinality(symbolTermUnpacked)) != null) {
            symbolTermUnpacked = TermUtils.toApplAt(symbolTermUnpacked, 0);
        }
        if (syntaxContext == null && (syntaxContext = this.getSyntaxContext(symbolTermUnpacked)) != null) {
            symbolTermUnpacked = TermUtils.toApplAt(symbolTermUnpacked, 0);
        }
        switch (TermUtils.asAppl(symbolTermUnpacked).map(s -> s.getConstructor().getName()).orElse("")) {
            case "layout": 
            case "lit": 
            case "sort": 
            case "cilit": 
            case "parameterized-sort": {
                return this.readNonTerminal(symbolTermUnpacked, syntaxContext, cardinality);
            }
            case "char-class": {
                return this.readTerminal(symbolTermUnpacked, syntaxContext, cardinality);
            }
            case "alt": {
                ISymbol first = this.read(TermUtils.toApplAt(symbolTermUnpacked, 0));
                ISymbol second = this.read(TermUtils.toApplAt(symbolTermUnpacked, 1));
                return new AltSymbol(syntaxContext, cardinality, first, second);
            }
            case "seq": {
                ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
                if (symbolTermUnpacked.getSubtermCount() == 2) {
                    symbols.add(this.read(TermUtils.toApplAt(symbolTermUnpacked, 0)));
                    IStrategoTerm[] iStrategoTermArray = symbolTermUnpacked.getSubterm(1).getAllSubterms();
                    int n = iStrategoTermArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStrategoTerm tailTerm = iStrategoTermArray[n2];
                        symbols.add(this.read(TermUtils.toAppl(tailTerm)));
                        ++n2;
                    }
                } else if (symbolTermUnpacked.getSubtermCount() == 1) {
                    for (IStrategoTerm tailTerm : symbolTermUnpacked.getSubterm(0)) {
                        symbols.add(this.read(TermUtils.toAppl(tailTerm)));
                    }
                } else {
                    throw new ParseTableReadException("invalid sequence term constructor: " + symbolTerm);
                }
                return new SequenceSymbol(syntaxContext, cardinality, symbols);
            }
        }
        throw new ParseTableReadException("invalid symbol term constructor: " + symbolTerm);
    }

    private SyntaxContext getSyntaxContext(IStrategoAppl symbolTermUnpacked) {
        switch (TermUtils.tryGetName(symbolTermUnpacked).orElse("")) {
            case "cf": {
                return SyntaxContext.ContextFree;
            }
            case "lex": {
                return SyntaxContext.Lexical;
            }
        }
        return null;
    }

    private SortCardinality getSortCardinality(IStrategoAppl symbolTermUnpacked) {
        switch (TermUtils.tryGetName(symbolTermUnpacked).orElse("")) {
            case "opt": {
                return SortCardinality.Optional;
            }
            case "iter": {
                return SortCardinality.Iter;
            }
            case "iter-sep": {
                return SortCardinality.IterSep;
            }
            case "iter-star": {
                return SortCardinality.IterStar;
            }
            case "iter-star-sep": {
                return SortCardinality.IterStarSep;
            }
            case "iter-plus": {
                return SortCardinality.IterPlus;
            }
            case "iter-plus-sep": {
                return SortCardinality.IterPlusSep;
            }
        }
        return null;
    }

    private INonTerminalSymbol readNonTerminal(IStrategoAppl nonTerminalTerm, SyntaxContext syntaxContext, SortCardinality cardinality) throws ParseTableReadException {
        switch (TermUtils.tryGetName(nonTerminalTerm).orElse("")) {
            case "sort": {
                String sort = TermUtils.toJavaStringAt(nonTerminalTerm, 0);
                return new SortSymbol(syntaxContext, cardinality, sort);
            }
            case "parameterized-sort": {
                String sortBase = TermUtils.toJavaStringAt(nonTerminalTerm, 0);
                IStrategoList sortParametersTermList = TermUtils.toListAt(nonTerminalTerm, 1);
                String[] sortParameters = new String[sortParametersTermList.size()];
                int index = 0;
                while (!sortParametersTermList.isEmpty()) {
                    sortParameters[index] = TermUtils.toJavaStringAt(sortParametersTermList.head(), 0);
                    ++index;
                    sortParametersTermList = sortParametersTermList.tail();
                }
                return new ParameterizedSortSymbol(syntaxContext, cardinality, sortBase, sortParameters);
            }
            case "lit": 
            case "cilit": {
                String literal = TermUtils.toJavaStringAt(nonTerminalTerm, 0);
                return new LiteralSymbol(syntaxContext, cardinality, literal);
            }
            case "layout": {
                return new LayoutSymbol(syntaxContext, cardinality);
            }
        }
        throw new ParseTableReadException("invalid nonterminal constructor: " + nonTerminalTerm);
    }

    private ITerminalSymbol readTerminal(IStrategoAppl terminalTerm, SyntaxContext syntaxContext, SortCardinality cardinality) {
        IStrategoList characterClassTermList = TermUtils.toListAt(terminalTerm, 0);
        ICharacterClass characterClass = this.characterClassReader.read(characterClassTermList);
        return new TerminalSymbol(characterClass, syntaxContext, cardinality);
    }

    private IMetaVarSymbol readMetaVar(IStrategoAppl metaVarTerm) {
        MetaVarCardinality metaVarCardinality;
        if ("cf".equals(TermUtils.tryGetName(metaVarTerm).orElse(""))) {
            metaVarTerm = TermUtils.toApplAt(metaVarTerm, 0);
        }
        switch (TermUtils.tryGetName(metaVarTerm).orElse("")) {
            case "iter-plus": 
            case "iter-star": 
            case "iter": 
            case "iter-star-sep": 
            case "iter-sep": 
            case "iter-plus-sep": {
                metaVarCardinality = MetaVarCardinality.ListVar;
                break;
            }
            default: {
                metaVarCardinality = MetaVarCardinality.Var;
            }
        }
        return new MetaVarSymbol(metaVarCardinality);
    }
}

