/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.productions;

import org.metaborg.parsetable.symbols.ConcreteSyntaxContext;
import org.metaborg.parsetable.symbols.ISymbol;

public interface IProduction {
    public int id();

    public ISymbol lhs();

    public String sort();

    public String startSymbolSort();

    public String constructor();

    public static boolean isListConstructor(String constructor) {
        return "Snoc".equals(constructor) || "Ins".equals(constructor) || "Nil".equals(constructor);
    }

    public String descriptor();

    public ConcreteSyntaxContext concreteSyntaxContext();

    default public boolean isContextFree() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.ContextFree;
    }

    default public boolean isLayout() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.Layout;
    }

    default public boolean isLiteral() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.Literal;
    }

    default public boolean isLexical() {
        return this.concreteSyntaxContext() == ConcreteSyntaxContext.Lexical;
    }

    default public boolean isSkippableInParseForest() {
        return !this.isContextFree();
    }

    public boolean isList();

    public boolean isOptional();

    public boolean isRecovery();

    default public boolean isWater() {
        return this.sort() != null && this.sort().contains("WATER") || "WATER".equals(this.constructor());
    }

    default public boolean isInsertion() {
        return "INSERTION".equals(this.constructor());
    }

    public boolean isCompletion();

    public boolean isStringLiteral();

    public boolean isNumberLiteral();

    public boolean isOperator();

    public boolean isIgnoreLayoutConstraint();

    public boolean isLongestMatch();

    public boolean isBracket();

    public boolean isNonAssocWith(IProduction var1);

    public boolean isNonNestedWith(IProduction var1);
}

