/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.source;

import org.metaborg.core.source.ISourceRegion;

public class SourceRegion
implements ISourceRegion {
    private static final long serialVersionUID = -3699054067428073315L;
    private final int startOffset;
    private final int startRow;
    private final int startColumn;
    private final int endOffset;
    private final int endRow;
    private final int endColumn;

    public SourceRegion(int offset) {
        this.startOffset = offset;
        this.startRow = -1;
        this.startColumn = -1;
        this.endOffset = offset;
        this.endRow = -1;
        this.endColumn = -1;
    }

    public SourceRegion(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.startRow = -1;
        this.startColumn = -1;
        this.endOffset = endOffset;
        this.endRow = -1;
        this.endColumn = -1;
    }

    public SourceRegion(int startOffset, int startRow, int startColumn, int endOffset, int endRow, int endColumn) {
        this.startOffset = startOffset;
        this.startRow = startRow;
        this.startColumn = startColumn;
        this.endOffset = endOffset;
        this.endRow = endRow;
        this.endColumn = endColumn;
    }

    @Override
    public int startOffset() {
        return this.startOffset;
    }

    @Override
    public int startRow() {
        return this.startRow;
    }

    @Override
    public int startColumn() {
        return this.startColumn;
    }

    @Override
    public int endOffset() {
        return this.endOffset;
    }

    @Override
    public int endRow() {
        return this.endRow;
    }

    @Override
    public int endColumn() {
        return this.endColumn;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset + 1;
    }

    @Override
    public boolean contains(ISourceRegion region) {
        return region.startOffset() >= this.startOffset && region.startOffset() <= this.endOffset() && region.endOffset() <= this.endOffset();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.startRow;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endRow;
        result = 31 * result + this.endColumn;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceRegion other = (SourceRegion)obj;
        if (this.startRow != other.startRow) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.endRow != other.endRow) {
            return false;
        }
        return this.endColumn == other.endColumn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.startOffset);
        sb.append("-");
        sb.append(this.endOffset);
        if (this.startRow >= 0 && this.endRow >= 0) {
            sb.append(" ");
            sb.append(this.startRow);
            sb.append("-");
            sb.append(this.endRow);
        }
        if (this.startColumn >= 0 && this.endColumn >= 0) {
            sb.append(" ");
            sb.append(this.startColumn);
            sb.append("-");
            sb.append(this.endColumn);
        }
        return sb.toString();
    }
}

