/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.project;

import com.google.inject.Inject;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.IProjectConfigService;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.project.Project;

public class SingleFileProjectService
implements IProjectService {
    private final IProjectConfigService projectConfigService;

    @Inject
    public SingleFileProjectService(IProjectConfigService projectConfigService) {
        this.projectConfigService = projectConfigService;
    }

    @Override
    public IProject get(FileObject resource) {
        FileObject rootFolder = resource;
        try {
            if (resource.isFile()) {
                rootFolder = resource.getParent();
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        IProjectConfig config = this.projectConfigService.defaultConfig(rootFolder);
        return new Project(rootFolder, config);
    }
}

