/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.messages;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.IMessagePrinter;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.core.project.IProject;
import org.metaborg.core.source.AffectedSourceHelper;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.core.source.ISourceTextService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;
import org.metaborg.util.log.LoggerUtils;

public class StreamMessagePrinter
implements IMessagePrinter {
    private final ISourceTextService sourceTextService;
    private final PrintStream infoStream;
    private final PrintStream warnStream;
    private final PrintStream errorStream;
    private final boolean printHighlight;
    private final boolean printExceptions;
    private int notes = 0;
    private int warnings = 0;
    private int warningsPardoned = 0;
    private int errors = 0;
    private int errorsPardoned = 0;
    private int exceptions = 0;
    private int exceptionsPardoned = 0;

    public StreamMessagePrinter(ISourceTextService sourceTextService, boolean printHighlight, boolean printExceptions, OutputStream infoStream, OutputStream warnStream, OutputStream errorStream) {
        this.sourceTextService = sourceTextService;
        this.infoStream = new PrintStream(infoStream);
        this.warnStream = new PrintStream(warnStream);
        this.errorStream = new PrintStream(errorStream);
        this.printHighlight = printHighlight;
        this.printExceptions = printExceptions;
    }

    public StreamMessagePrinter(ISourceTextService sourceTextService, boolean printHighlight, boolean printExceptions, ILogger logger) {
        this(sourceTextService, printHighlight, printExceptions, LoggerUtils.stream(logger, Level.Info, new String[0]), LoggerUtils.stream(logger, Level.Warn, new String[0]), LoggerUtils.stream(logger, Level.Error, new String[0]));
    }

    @Override
    public void print(IMessage message, boolean pardoned) {
        StringBuilder sb = new StringBuilder();
        MessageSeverity severity = message.severity();
        sb.append(severity);
        if (severity != MessageSeverity.NOTE && pardoned) {
            sb.append(" (pardoned)");
        }
        FileObject source = message.source();
        ISourceRegion region = message.region();
        if (source != null) {
            sb.append(" in ");
            sb.append(source.getName().getURI());
            if (region != null) {
                sb.append(":").append(region.startRow());
            }
            sb.append('\n');
        }
        if (this.printHighlight && source != null && region != null) {
            try {
                String sourceText = this.sourceTextService.text(source);
                String affected = AffectedSourceHelper.affectedSourceText(message.region(), sourceText, "    ");
                if (affected != null) {
                    sb.append(affected);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.print(sb, message.message(), message.exception(), message.severity(), pardoned);
        switch (severity) {
            case NOTE: {
                ++this.notes;
                break;
            }
            case WARNING: {
                if (pardoned) {
                    ++this.warningsPardoned;
                    break;
                }
                ++this.warnings;
                break;
            }
            case ERROR: {
                if (pardoned) {
                    ++this.errorsPardoned;
                    break;
                }
                ++this.errors;
            }
        }
    }

    @Override
    public void print(@Nullable FileObject source, String message, @Nullable Throwable e, boolean pardoned) {
        StringBuilder sb = new StringBuilder();
        sb.append("EXCEPTION");
        if (pardoned) {
            sb.append(" (pardoned)");
        }
        sb.append(" in ");
        sb.append(source != null ? source.getName().getPath() : "detached source");
        sb.append('\n');
        this.print(sb, message, e, MessageSeverity.ERROR, pardoned);
        if (pardoned) {
            ++this.exceptionsPardoned;
        } else {
            ++this.exceptions;
        }
    }

    @Override
    public void print(IProject project, String message, @Nullable Throwable e, boolean pardoned) {
        StringBuilder sb = new StringBuilder();
        sb.append("EXCEPTION");
        if (pardoned) {
            sb.append(" (pardoned)");
        }
        sb.append(" in project ");
        sb.append(project.location().getName().getPath());
        sb.append('\n');
        this.print(sb, message, e, MessageSeverity.ERROR, pardoned);
        if (pardoned) {
            ++this.exceptionsPardoned;
        } else {
            ++this.exceptions;
        }
    }

    private void print(StringBuilder sb, String message, @Nullable Throwable e, MessageSeverity severity, boolean pardoned) {
        sb.append(message);
        sb.append('\n');
        if (this.printExceptions && e != null) {
            sb.append("\tCaused by:\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            sb.append(sw.toString());
            sb.append('\n');
        }
        sb.append('\n');
        String str = sb.toString();
        if (pardoned) {
            this.infoStream.print(str);
            this.infoStream.flush();
        } else {
            switch (severity) {
                case NOTE: {
                    this.infoStream.print(str);
                    this.infoStream.flush();
                    break;
                }
                case WARNING: {
                    this.warnStream.print(str);
                    this.warnStream.flush();
                    break;
                }
                case ERROR: {
                    this.errorStream.print(str);
                    this.errorStream.flush();
                }
            }
        }
    }

    @Override
    public void printSummary() {
        int total = this.notes + this.warnings + this.warningsPardoned + this.errors + this.errorsPardoned + this.exceptions + this.exceptionsPardoned;
        if (total == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(total);
        sb.append(" messages (");
        sb.append(this.exceptions);
        sb.append(" exception");
        if (this.exceptions == 0 || this.exceptions > 1) {
            sb.append('s');
        }
        if (this.exceptionsPardoned > 0) {
            sb.append(" [");
            sb.append(this.exceptionsPardoned);
            sb.append(" pardoned]");
        }
        sb.append(", ");
        sb.append(this.errors);
        sb.append(" error");
        if (this.errors == 0 || this.errors > 1) {
            sb.append('s');
        }
        if (this.errorsPardoned > 0) {
            sb.append(" [");
            sb.append(this.errorsPardoned);
            sb.append(" pardoned]");
        }
        sb.append(", ");
        sb.append(this.warnings);
        sb.append(" warning");
        if (this.warnings == 0 || this.warnings > 1) {
            sb.append('s');
        }
        if (this.warningsPardoned > 0) {
            sb.append(" [");
            sb.append(this.warningsPardoned);
            sb.append(" pardoned]");
        }
        sb.append(", ");
        sb.append(this.notes);
        sb.append(" note");
        if (this.notes == 0 || this.notes > 1) {
            sb.append('s');
        }
        sb.append(')');
        sb.append('\n');
        String str = sb.toString();
        this.infoStream.print(str);
        this.infoStream.flush();
    }
}

