/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.AConfigService;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.config.IConfig;
import org.metaborg.core.config.IProjectConfig;
import org.metaborg.core.config.IProjectConfigService;
import org.metaborg.core.config.IProjectConfigWriter;
import org.metaborg.core.config.ProjectConfig;
import org.metaborg.core.config.ProjectConfigBuilder;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;
import org.metaborg.core.project.IProject;

public class ProjectConfigService
extends AConfigService<IProject, IProjectConfig>
implements IProjectConfigService,
IProjectConfigWriter {
    private final ProjectConfigBuilder configBuilder;

    @Inject
    public ProjectConfigService(AConfigurationReaderWriter configReaderWriter, ProjectConfigBuilder configBuilder) {
        super(configReaderWriter);
        this.configBuilder = configBuilder;
    }

    @Override
    public IProjectConfig defaultConfig(FileObject rootFolder) {
        this.configBuilder.reset();
        return this.configBuilder.build(rootFolder);
    }

    @Override
    protected FileObject getRootDirectory(IProject project) throws FileSystemException {
        return project.location();
    }

    @Override
    protected FileObject getConfigFile(FileObject rootFolder) throws FileSystemException {
        return rootFolder.resolveFile("metaborg.yaml");
    }

    @Override
    protected ConfigRequest<IProjectConfig> toConfig(HierarchicalConfiguration<ImmutableNode> config, FileObject configFile) {
        ProjectConfig projectConfig = new ProjectConfig(config);
        MessageBuilder mb = MessageBuilder.create().asError().asInternal().withSource(configFile);
        Collection<IMessage> messages = projectConfig.validate(mb);
        return new ConfigRequest<IProjectConfig>(projectConfig, messages);
    }

    @Override
    protected HierarchicalConfiguration<ImmutableNode> fromConfig(IProjectConfig config) {
        if (!(config instanceof IConfig)) {
            this.configBuilder.reset();
            this.configBuilder.copyFrom(config);
            config = this.configBuilder.build((FileObject)null);
        }
        return ((IConfig)((Object)config)).getConfig();
    }
}

