/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.build.FilesBuildState;
import org.metaborg.core.build.LanguageBuildDiff;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.IdentifiedResource;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.core.resource.IdentifiedResourceChange;
import org.metaborg.core.resource.ResourceChange;
import org.metaborg.core.resource.ResourceChangeKind;
import org.metaborg.util.iterators.Iterables2;

public class LanguageBuildState {
    private final IResourceService resourceService;
    private final ILanguageIdentifierService languageIdentifierService;
    private final ILanguageImpl language;
    private final FilesBuildState source = new FilesBuildState();
    private final FilesBuildState include = new FilesBuildState();

    public LanguageBuildState(IResourceService resourceService, ILanguageIdentifierService languageIdentifierService, ILanguageImpl language) {
        this.resourceService = resourceService;
        this.languageIdentifierService = languageIdentifierService;
        this.language = language;
    }

    public LanguageBuildDiff diff(Iterable<IdentifiedResourceChange> sourceFileChanges, Iterable<IdentifiedResource> newIncludeFiles) {
        LanguageBuildState newState = this.copy();
        this.sourceDiff(newState, sourceFileChanges);
        Iterable<IdentifiedResourceChange> includeFileChanges = this.includeDiff(newState, newIncludeFiles);
        return new LanguageBuildDiff(newState, sourceFileChanges, includeFileChanges);
    }

    private LanguageBuildState copy() {
        LanguageBuildState newState = new LanguageBuildState(this.resourceService, this.languageIdentifierService, this.language);
        newState.source.add(this.source);
        newState.include.add(this.include);
        return newState;
    }

    private void sourceDiff(LanguageBuildState newState, Iterable<IdentifiedResourceChange> changes) {
        for (IdentifiedResourceChange identifiedChange : changes) {
            ResourceChange change = identifiedChange.change;
            switch (change.kind) {
                case Create: {
                    newState.source.add(change.resource);
                    break;
                }
                case Delete: {
                    newState.source.remove(change.resource.getName());
                    break;
                }
                case Rename: {
                    FileObject from = change.from;
                    if (from != null) {
                        newState.source.remove(from.getName());
                    }
                    newState.source.add(change.to);
                    break;
                }
                case Copy: {
                    newState.source.add(change.to);
                    break;
                }
            }
        }
    }

    private Iterable<IdentifiedResourceChange> includeDiff(LanguageBuildState newState, Iterable<IdentifiedResource> newFiles) {
        FileObject resource;
        LinkedList changes = Lists.newLinkedList();
        HashSet existingFiles = Sets.newHashSet(this.include.files);
        for (IdentifiedResource identifiedResource : newFiles) {
            resource = identifiedResource.resource;
            FileName name = resource.getName();
            long newModification = newState.include.add(resource);
            existingFiles.remove(name);
            if (this.include.files.contains(name)) {
                long existingModification = this.include.modification.get(name);
                if (existingModification == newModification) continue;
                changes.add(new IdentifiedResourceChange(new ResourceChange(resource, ResourceChangeKind.Modify), identifiedResource));
                continue;
            }
            changes.add(new IdentifiedResourceChange(new ResourceChange(resource, ResourceChangeKind.Create), identifiedResource));
        }
        for (FileName name : existingFiles) {
            newState.include.remove(name);
            resource = this.resourceService.resolve(name.getURI());
            IdentifiedResource identifiedResource = this.languageIdentifierService.identifyToResource(resource, Iterables2.singleton(this.language));
            if (identifiedResource == null) continue;
            changes.add(new IdentifiedResourceChange(new ResourceChange(resource, ResourceChangeKind.Delete), identifiedResource));
        }
        return changes;
    }
}

