/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPropertyPrimitive;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_get_all_properties
extends StatixPropertyPrimitive {
    @Inject
    public STX_get_all_properties() {
        super(STX_get_all_properties.class.getSimpleName(), 1);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        SolverResult analysis = TermMatch.M.blobValue(SolverResult.class).match(terms.get(0)).orElseThrow(() -> new InterpreterException("Expected solver result."));
        TreeMap<TermIndex, SortedMap> groupedProps = new TreeMap<TermIndex, SortedMap>(TermIndexComparator.instance);
        for (Map.Entry prop : analysis.state().termProperties().entrySet()) {
            TermIndex index = (TermIndex)((Tuple2)prop.getKey())._1();
            ITerm propName = (ITerm)((Tuple2)prop.getKey())._2();
            ITermProperty propValue = (ITermProperty)prop.getValue();
            SortedMap group = groupedProps.computeIfAbsent(index, __ -> new TreeMap(PropComparator.instance));
            group.put(propName, propValue);
        }
        ImmutableList.Builder propSets = ImmutableList.builder();
        for (Map.Entry rawSet : groupedProps.entrySet()) {
            ImmutableList.Builder props = ImmutableList.builder();
            TermIndex index = (TermIndex)rawSet.getKey();
            for (Map.Entry rawProp : ((SortedMap)rawSet.getValue()).entrySet()) {
                ITerm name = (ITerm)rawProp.getKey();
                ITerm value = this.instantiateValue((ITermProperty)rawProp.getValue(), analysis);
                ITerm multiplicity = this.explicate(((ITermProperty)rawProp.getValue()).multiplicity());
                props.add((Object)TermBuild.B.newAppl("StxProp", name, value, multiplicity));
            }
            propSets.add((Object)TermBuild.B.newTuple(index, TermBuild.B.newList((Iterable<? extends ITerm>)props.build())));
        }
        return Optional.of(TermBuild.B.newAppl("Properties", TermBuild.B.newList((Iterable<? extends ITerm>)propSets.build())));
    }

    private static class PropComparator
    implements Comparator<ITerm> {
        public static final PropComparator instance = new PropComparator();
        private static final TermMatch.IMatcher<String> propNames = TermMatch.M.appl1("Prop", TermMatch.M.stringValue(), (appl, val) -> val);

        private PropComparator() {
        }

        @Override
        public int compare(ITerm prop1, ITerm prop2) {
            boolean firstType = prop1.equals(PROP_TYPE);
            boolean secondType = prop2.equals(PROP_TYPE);
            if (firstType) {
                return secondType ? 0 : -1;
            }
            if (secondType) {
                return 1;
            }
            boolean firstRef = prop1.equals(PROP_REF);
            boolean secondRef = prop2.equals(PROP_REF);
            if (firstRef) {
                return secondRef ? 0 : -1;
            }
            if (secondRef) {
                return 1;
            }
            String name1 = this.getPropName(prop1);
            String name2 = this.getPropName(prop2);
            return name1.compareTo(name2);
        }

        private String getPropName(ITerm prop) {
            return propNames.match(prop).orElseThrow(() -> new IllegalStateException("Expected prop, got " + prop));
        }
    }

    private static class TermIndexComparator
    implements Comparator<TermIndex> {
        public static final TermIndexComparator instance = new TermIndexComparator();

        private TermIndexComparator() {
        }

        @Override
        public int compare(TermIndex index1, TermIndex index2) {
            int resource = index1.getResource().compareTo(index2.getResource());
            return resource != 0 ? resource : Integer.compare(index1.getId(), index2.getId());
        }
    }
}

