/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import mb.nabl2.terms.stratego.StrategoBlob;
import mb.scopegraph.oopsla20.reference.LabelOrder;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

final class LabelUtils {
    private static final String EOP_OP = "EOP";
    private static final String LABEL_PAIR_OP = "LabelPair";

    private LabelUtils() {
    }

    static boolean isEOP(IStrategoTerm lbl) {
        return TermUtils.isAppl(lbl, EOP_OP, 0);
    }

    static IStrategoTerm normalizeLabel(IStrategoTerm lbl, IStrategoTerm relation) {
        return LabelUtils.isEOP(lbl) ? relation : lbl;
    }

    static Tuple2<IStrategoTerm, IStrategoTerm> parseLabelPair(IStrategoTerm labelPair) {
        if (!TermUtils.isAppl(labelPair, LABEL_PAIR_OP, 2) && !TermUtils.isTuple(labelPair, 2)) {
            throw new IllegalArgumentException("Expected label pair, got " + labelPair);
        }
        return Tuple2.of(labelPair.getSubterm(0), labelPair.getSubterm(1));
    }

    static LabelOrder<IStrategoTerm> readLabelOrderBlob(IStrategoTerm blob) {
        if (!(blob instanceof StrategoBlob)) {
            throw new IllegalArgumentException("Expecter label order blob, got " + blob);
        }
        Object orderValue = ((StrategoBlob)blob).value();
        if (!(orderValue instanceof LabelOrder)) {
            throw new IllegalArgumentException("Expecter label order as blob argument, got " + orderValue);
        }
        LabelOrder labelOrder = (LabelOrder)orderValue;
        return labelOrder;
    }
}

