/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mb.nabl2.terms.ITerm;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.spec.ARule;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import org.metaborg.util.tuple.Tuple2;

public final class RuleSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableListMultimap<String, Rule> rules;
    private final Map<String, ImmutableSet<Rule>> independentRules = new HashMap<String, ImmutableSet<Rule>>();

    public static RuleSet of(Collection<Rule> rules) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder().orderValuesBy(Rule.leftRightPatternOrdering.asComparator());
        rules.forEach(rule -> {
            ImmutableListMultimap.Builder builder2 = builder.put((Object)rule.name(), rule);
        });
        return new RuleSet((ListMultimap<String, Rule>)builder.build());
    }

    public RuleSet(ListMultimap<String, Rule> rules) {
        this.rules = ImmutableListMultimap.copyOf(rules);
    }

    public ImmutableListMultimap<String, Rule> getRuleMap() {
        return this.rules;
    }

    public ImmutableSet<String> getRuleNames() {
        return this.rules.keySet();
    }

    public ImmutableCollection<Rule> getAllRules() {
        return this.rules.values();
    }

    public ImmutableList<Rule> getRules(String name) {
        return this.rules.get((Object)name);
    }

    public ImmutableListMultimap<String, Rule> getAllOrderIndependentRules() {
        ImmutableListMultimap.Builder independentRules = ImmutableListMultimap.builder();
        this.rules.keySet().forEach(name -> {
            ImmutableListMultimap.Builder builder2 = independentRules.putAll(name, this.getOrderIndependentRules((String)name));
        });
        return independentRules.build();
    }

    public ImmutableSet<Rule> getOrderIndependentRules(String name) {
        return this.independentRules.computeIfAbsent(name, n -> RuleUtil.computeOrderIndependentRules(this.getRules(name)));
    }

    public ListMultimap<String, Rule> getAllEquivalentRules() {
        ImmutableListMultimap.Builder overlappingRules = ImmutableListMultimap.builder();
        this.rules.keySet().forEach(name -> {
            ImmutableListMultimap.Builder builder2 = overlappingRules.putAll(name, this.getEquivalentRules((String)name));
        });
        return overlappingRules.build();
    }

    public ImmutableSet<Rule> getEquivalentRules(String name) {
        ImmutableList<Rule> rules = this.getRules(name);
        return (ImmutableSet)rules.stream().filter(a -> rules.stream().anyMatch(b -> !a.equals(b) && ARule.leftRightPatternOrdering.compare((Rule)a, (Rule)b).map(c -> c == 0).orElse(false) != false)).collect(ImmutableSet.toImmutableSet());
    }

    public RuleSet precomputeCriticalEdges(SetMultimap<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        ImmutableListMultimap.Builder newRules = ImmutableListMultimap.builder();
        for (String name : this.rules.keySet()) {
            for (Rule rule : this.rules.get((Object)name)) {
                Rule newRule = CompletenessUtil.precomputeCriticalEdges(rule, scopeExtensions);
                newRules.put((Object)name, (Object)newRule);
            }
        }
        return new RuleSet((ListMultimap<String, Rule>)newRules.build());
    }
}

