/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.AApplyResult;

public final class ApplyResult
extends AApplyResult
implements Serializable {
    private final Diseq guard;
    private final IConstraint body;
    private final ICompleteness.Immutable criticalEdges;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private ApplyResult(Optional<? extends Diseq> guard, IConstraint body, ICompleteness.Immutable criticalEdges) {
        this.guard = guard.orElse(null);
        this.body = Objects.requireNonNull(body, "body");
        this.criticalEdges = Objects.requireNonNull(criticalEdges, "criticalEdges");
    }

    private ApplyResult(ApplyResult original, Diseq guard, IConstraint body, ICompleteness.Immutable criticalEdges) {
        this.guard = guard;
        this.body = body;
        this.criticalEdges = criticalEdges;
    }

    @Override
    public Optional<Diseq> guard() {
        return Optional.ofNullable(this.guard);
    }

    @Override
    public IConstraint body() {
        return this.body;
    }

    @Override
    public ICompleteness.Immutable criticalEdges() {
        return this.criticalEdges;
    }

    public final ApplyResult withGuard(Diseq value) {
        Diseq newValue = Objects.requireNonNull(value, "guard");
        if (this.guard == newValue) {
            return this;
        }
        return new ApplyResult(this, newValue, this.body, this.criticalEdges);
    }

    public final ApplyResult withGuard(Optional<? extends Diseq> optional) {
        Diseq value = optional.orElse(null);
        if (this.guard == value) {
            return this;
        }
        return new ApplyResult(this, value, this.body, this.criticalEdges);
    }

    public final ApplyResult withBody(IConstraint value) {
        if (this.body == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "body");
        return new ApplyResult(this, this.guard, newValue, this.criticalEdges);
    }

    public final ApplyResult withCriticalEdges(ICompleteness.Immutable value) {
        if (this.criticalEdges == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "criticalEdges");
        return new ApplyResult(this, this.guard, this.body, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplyResult && this.equalTo((ApplyResult)another);
    }

    private boolean equalTo(ApplyResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.guard, another.guard) && this.body.equals(another.body) && this.criticalEdges.equals(another.criticalEdges);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guard);
        h += (h << 5) + this.body.hashCode();
        h += (h << 5) + this.criticalEdges.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ApplyResult").omitNullValues().add("guard", (Object)this.guard).add("body", (Object)this.body).add("criticalEdges", (Object)this.criticalEdges).toString();
    }

    public static ApplyResult of(Optional<? extends Diseq> guard, IConstraint body, ICompleteness.Immutable criticalEdges) {
        return new ApplyResult(guard, body, criticalEdges);
    }

    public static ApplyResult copyOf(AApplyResult instance) {
        if (instance instanceof ApplyResult) {
            return (ApplyResult)instance;
        }
        return ApplyResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ApplyResult(ApplyResult applyResult, Diseq diseq, IConstraint iConstraint, ICompleteness.Immutable immutable, ApplyResult applyResult2) {
        this(applyResult, diseq, iConstraint, immutable);
    }

    public static final class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private static final long INIT_BIT_CRITICAL_EDGES = 2L;
        private long initBits = 3L;
        private Diseq guard;
        private IConstraint body;
        private ICompleteness.Immutable criticalEdges;

        private Builder() {
        }

        public final Builder from(AApplyResult instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Diseq> guardOptional = instance.guard();
            if (guardOptional.isPresent()) {
                this.guard(guardOptional);
            }
            this.body(instance.body());
            this.criticalEdges(instance.criticalEdges());
            return this;
        }

        public final Builder guard(Diseq guard) {
            this.guard = Objects.requireNonNull(guard, "guard");
            return this;
        }

        public final Builder guard(Optional<? extends Diseq> guard) {
            this.guard = guard.orElse(null);
            return this;
        }

        public final Builder body(IConstraint body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder criticalEdges(ICompleteness.Immutable criticalEdges) {
            this.criticalEdges = Objects.requireNonNull(criticalEdges, "criticalEdges");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ApplyResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplyResult(null, this.guard, this.body, this.criticalEdges, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("criticalEdges");
            }
            return "Cannot build ApplyResult, some of required attributes are not set " + attributes;
        }
    }
}

