/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints.messages;

import com.google.common.collect.ImmutableMap;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.solver.ACriticalEdge;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.SolverResult;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

public class MessageUtil {
    private static final Map<Class<? extends IConstraint>, MessageKind> KINDS = ImmutableMap.builder().put(CAstId.class, (Object)MessageKind.IGNORE).put(CAstProperty.class, (Object)MessageKind.IGNORE).build();

    public static IMessage findClosestMessage(IConstraint c) {
        return MessageUtil.findClosestMessage(c, KINDS.getOrDefault(c.getClass(), MessageKind.ERROR));
    }

    public static IMessage findClosestMessage(IConstraint c, MessageKind kind) {
        IMessage message = null;
        while (c != null) {
            IMessage m = c.message().orElse(null);
            if (m != null && (message == null || message.kind().isWorseThan(m.kind()))) {
                message = m;
            }
            c = c.cause().orElse(null);
        }
        if (message == null) {
            message = new Message(kind);
        }
        return message;
    }

    public static SolverResult delaysAsErrors(SolverResult result, boolean suppressCascadingErrors) {
        ImmutableMap delays;
        block5: {
            Set.Immutable newErrorVars;
            delays = result.delays();
            if (!suppressCascadingErrors) break block5;
            IUniDisunifier.Immutable unifier = result.state().unifier();
            Set.Immutable allErrorVars = newErrorVars = (Set.Immutable)result.messages().entrySet().stream().filter(e -> ((IMessage)e.getValue()).kind().equals(MessageKind.ERROR)).map(Map.Entry::getKey).flatMap(c -> c.freeVars().stream()).flatMap(v -> unifier.findRecursive((ITerm)v).getVars().stream()).collect(CapsuleCollectors.toSet());
            Set.Immutable newCriticalEdges = CapsuleUtil.immutableSet();
            Set.Immutable allCriticalEdges = CapsuleUtil.immutableSet();
            while (!newErrorVars.isEmpty() || !newCriticalEdges.isEmpty()) {
                Set.Transient _newVars = CapsuleUtil.transientSet();
                Set.Transient _newCriticalEdges = CapsuleUtil.transientSet();
                ImmutableMap.Builder retainedDelays = ImmutableMap.builder();
                for (Map.Entry e2 : delays.entrySet()) {
                    block7: {
                        block6: {
                            Delay d2 = (Delay)e2.getValue();
                            if (d2.vars().stream().anyMatch(arg_0 -> ((Set.Immutable)newErrorVars).contains(arg_0))) break block6;
                            if (!d2.criticalEdges().stream().anyMatch(arg_0 -> ((Set.Immutable)newCriticalEdges).contains(arg_0))) break block7;
                        }
                        for (ITermVar var : ((IConstraint)e2.getKey()).freeVars()) {
                            _newVars.__insertAll((Set)unifier.findRecursive(var).getVars().__removeAll((Set)allErrorVars));
                        }
                        for (Map.Entry<ITerm, MultiSet.Immutable<EdgeOrData<ITerm>>> criticalEdges : ((IConstraint)e2.getKey()).ownCriticalEdges().orElse(Completeness.Immutable.of()).entrySet()) {
                            ITerm scope = unifier.findRecursive(criticalEdges.getKey());
                            Set.Immutable edges = (Set.Immutable)criticalEdges.getValue().elementSet().stream().map(edge -> CriticalEdge.of(scope, edge)).collect(CapsuleCollectors.toSet());
                            _newCriticalEdges.__insertAll((Set)edges.__removeAll((Set)allCriticalEdges));
                        }
                        continue;
                    }
                    retainedDelays.put(e2);
                }
                delays = retainedDelays.build();
                newErrorVars = _newVars.freeze();
                allErrorVars = allErrorVars.__insertAll((Set)newErrorVars);
                newCriticalEdges = _newCriticalEdges.freeze();
                allCriticalEdges = allCriticalEdges.__insertAll((Set)newCriticalEdges);
            }
        }
        ImmutableMap.Builder messages = ImmutableMap.builder();
        messages.putAll(result.messages());
        delays.forEach((c, d) -> {
            ImmutableMap.Builder builder2 = messages.put(c, (Object)new Unsolved(MessageUtil.findClosestMessage(c), (Delay)d, c.ownCriticalEdges().orElse(null)));
        });
        return result.withMessages((Map<? extends IConstraint, ? extends IMessage>)messages.build()).withDelays((Map<? extends IConstraint, ? extends Delay>)ImmutableMap.of());
    }

    private static class Unsolved
    implements IMessage,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IMessage message;
        private final Delay delay;
        @Nullable
        private final ICompleteness.Immutable completeness;

        private Unsolved(IMessage message, Delay delay, @Nullable ICompleteness.Immutable completeness) {
            this.message = message;
            this.delay = delay;
            this.completeness = completeness;
        }

        @Override
        public MessageKind kind() {
            return this.message.kind();
        }

        @Override
        public String toString(TermFormatter formatter, Function0<String> getDefaultMessage, Function1<ICompleteness.Immutable, String> formatCompleteness) {
            StringBuilder sb = new StringBuilder("(unsolved)");
            String msg = this.message.toString(formatter, getDefaultMessage, formatCompleteness);
            if (!msg.isEmpty()) {
                sb.append(" ");
                sb.append(msg);
                sb.append(":");
            }
            sb.append(" delayed on");
            boolean first = true;
            if (!this.delay.vars().isEmpty()) {
                sb.append(" vars: ").append(this.delay.vars().stream().map(Object::toString).collect(Collectors.joining(", ")));
                first = false;
            }
            if (!this.delay.criticalEdges().isEmpty()) {
                if (!first) {
                    sb.append(" and");
                }
                sb.append(" critial edges: ").append(this.delay.criticalEdges().stream().map(ACriticalEdge::toString).collect(Collectors.joining(", ")));
                first = false;
            }
            if (this.completeness != null && !this.completeness.isEmpty()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(" preventing completion of ").append(formatCompleteness.apply(this.completeness));
            }
            return sb.toString();
        }

        @Override
        public Optional<ITerm> origin() {
            return this.message.origin();
        }

        @Override
        public void visitVars(Action1<ITermVar> onVar) {
            this.message.visitVars(onVar);
        }

        @Override
        public IMessage apply(ISubstitution.Immutable subst) {
            return new Unsolved(this.message.apply(subst), this.delay, this.completeness == null ? null : this.completeness.apply(subst));
        }

        @Override
        public IMessage apply(IRenaming subst) {
            return new Unsolved(this.message.apply(subst), this.delay, this.completeness == null ? null : this.completeness.apply(subst));
        }
    }
}

