/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AGroupResult;
import mb.statix.concurrent.IStatixResult;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.SolverResult;

public final class GroupResult
extends AGroupResult
implements Serializable {
    private final String resource;
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> groupResults;
    private final ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> unitResults;
    @Nullable
    private final SolverResult solveResult;
    @Nullable
    private final Throwable exception;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private GroupResult(String resource, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> groupResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.groupResults = ImmutableMap.copyOf(groupResults);
        this.unitResults = ImmutableMap.copyOf(unitResults);
        this.solveResult = solveResult;
        this.exception = exception;
    }

    private GroupResult(GroupResult original, String resource, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> groupResults, ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        this.resource = resource;
        this.groupResults = groupResults;
        this.unitResults = unitResults;
        this.solveResult = solveResult;
        this.exception = exception;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> groupResults() {
        return this.groupResults;
    }

    public ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> unitResults() {
        return this.unitResults;
    }

    @Override
    @Nullable
    public SolverResult solveResult() {
        return this.solveResult;
    }

    @Override
    @Nullable
    public Throwable exception() {
        return this.exception;
    }

    public final GroupResult withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new GroupResult(this, newValue, this.groupResults, this.unitResults, this.solveResult, this.exception);
    }

    public final GroupResult withGroupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> entries) {
        if (this.groupResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new GroupResult(this, this.resource, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>>)newValue, this.unitResults, this.solveResult, this.exception);
    }

    public final GroupResult withUnitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> entries) {
        if (this.unitResults == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new GroupResult(this, this.resource, this.groupResults, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>>)newValue, this.solveResult, this.exception);
    }

    public final GroupResult withSolveResult(@Nullable SolverResult value) {
        if (this.solveResult == value) {
            return this;
        }
        return new GroupResult(this, this.resource, this.groupResults, this.unitResults, value, this.exception);
    }

    public final GroupResult withException(@Nullable Throwable value) {
        if (this.exception == value) {
            return this;
        }
        return new GroupResult(this, this.resource, this.groupResults, this.unitResults, this.solveResult, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupResult && this.equalTo((GroupResult)another);
    }

    private boolean equalTo(GroupResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && this.groupResults.equals(another.groupResults) && this.unitResults.equals(another.unitResults) && Objects.equals(this.solveResult, another.solveResult) && Objects.equals(this.exception, another.exception);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + this.groupResults.hashCode();
        h += (h << 5) + this.unitResults.hashCode();
        h += (h << 5) + Objects.hashCode(this.solveResult);
        h += (h << 5) + Objects.hashCode(this.exception);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GroupResult").omitNullValues().add("resource", (Object)this.resource).add("groupResults", this.groupResults).add("unitResults", this.unitResults).add("solveResult", (Object)this.solveResult).add("exception", (Object)this.exception).toString();
    }

    public static GroupResult of(String resource, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> groupResults, Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> unitResults, @Nullable SolverResult solveResult, @Nullable Throwable exception) {
        return new GroupResult(resource, groupResults, unitResults, solveResult, exception);
    }

    public static GroupResult copyOf(AGroupResult instance) {
        if (instance instanceof GroupResult) {
            return (GroupResult)instance;
        }
        return GroupResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ GroupResult(GroupResult groupResult, String string, ImmutableMap immutableMap, ImmutableMap immutableMap2, SolverResult solverResult, Throwable throwable, GroupResult groupResult2) {
        this(groupResult, string, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>>)immutableMap, (ImmutableMap<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>>)immutableMap2, solverResult, throwable);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private long initBits = 1L;
        private String resource;
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> groupResults = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> unitResults = ImmutableMap.builder();
        private SolverResult solveResult;
        private Throwable exception;

        private Builder() {
        }

        public final Builder from(IStatixResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AGroupResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SolverResult solveResultValue;
            Throwable exceptionValue;
            IStatixResult instance;
            long bits = 0L;
            if (object instanceof IStatixResult) {
                instance = (IStatixResult)object;
                if ((bits & 1L) == 0L) {
                    exceptionValue = instance.exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = instance.solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof AGroupResult) {
                instance = (AGroupResult)object;
                this.putAllGroupResults(((AGroupResult)instance).groupResults());
                if ((bits & 1L) == 0L) {
                    exceptionValue = ((AGroupResult)instance).exception();
                    if (exceptionValue != null) {
                        this.exception(exceptionValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    solveResultValue = ((AGroupResult)instance).solveResult();
                    if (solveResultValue != null) {
                        this.solveResult(solveResultValue);
                    }
                    bits |= 2L;
                }
                this.putAllUnitResults(((AGroupResult)instance).unitResults());
                this.resource(((AGroupResult)instance).resource());
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putGroupResults(String key, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>> value) {
            this.groupResults.put((Object)key, value);
            return this;
        }

        public final Builder putGroupResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> entry) {
            this.groupResults.put(entry);
            return this;
        }

        public final Builder groupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> entries) {
            this.groupResults = ImmutableMap.builder();
            return this.putAllGroupResults(entries);
        }

        public final Builder putAllGroupResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> entries) {
            this.groupResults.putAll(entries);
            return this;
        }

        public final Builder putUnitResults(String key, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>> value) {
            this.unitResults.put((Object)key, value);
            return this;
        }

        public final Builder putUnitResults(Map.Entry<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> entry) {
            this.unitResults.put(entry);
            return this;
        }

        public final Builder unitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> entries) {
            this.unitResults = ImmutableMap.builder();
            return this.putAllUnitResults(entries);
        }

        public final Builder putAllUnitResults(Map<String, ? extends IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> entries) {
            this.unitResults.putAll(entries);
            return this;
        }

        public final Builder solveResult(@Nullable SolverResult solveResult) {
            this.solveResult = solveResult;
            return this;
        }

        public final Builder exception(@Nullable Throwable exception) {
            this.exception = exception;
            return this;
        }

        public GroupResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GroupResult(null, this.resource, this.groupResults.build(), this.unitResults.build(), this.solveResult, this.exception, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            return "Cannot build GroupResult, some of required attributes are not set " + attributes;
        }
    }
}

