/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16;

import com.google.common.collect.ImmutableList;
import java.util.List;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.esop15.CriticalEdge;

public class CriticalEdgeException
extends Throwable {
    private static final long serialVersionUID = 1L;
    private final List<CriticalEdge> criticalEdges;

    public CriticalEdgeException(Iterable<CriticalEdge> criticalEdges) {
        super("incomplete", null, false, false);
        this.criticalEdges = ImmutableList.copyOf(criticalEdges);
        if (this.criticalEdges.isEmpty()) {
            throw new IllegalArgumentException("Critical edges cannot be empty.");
        }
    }

    public CriticalEdgeException(IScope scope, ILabel label) {
        this((Iterable<CriticalEdge>)ImmutableList.of((Object)CriticalEdge.of(scope, label)));
    }

    public List<CriticalEdge> criticalEdges() {
        return this.criticalEdges;
    }

    public static CriticalEdgeException of(Iterable<CriticalEdgeException> exceptions) {
        ImmutableList.Builder incompletes = ImmutableList.builder();
        exceptions.forEach(e -> {
            ImmutableList.Builder builder2 = incompletes.addAll(e.criticalEdges());
        });
        return new CriticalEdgeException((Iterable<CriticalEdge>)incompletes.build());
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("incomplete:");
        for (CriticalEdge ce : this.criticalEdges) {
            sb.append(" * ").append(ce);
        }
        return sb.toString();
    }
}

