/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.patching;

import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class IdentityMappingEntrySet<E>
extends AbstractSet<Map.Entry<E, E>> {
    private final Set<E> backingSet;

    IdentityMappingEntrySet(Set<E> backingSet) {
        this.backingSet = backingSet;
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        if (!IdentityMappingEntrySet.isIdentity(entry)) {
            return false;
        }
        return this.backingSet.contains(entry.getKey());
    }

    @Override
    public Iterator<Map.Entry<E, E>> iterator() {
        return Iterators.transform(this.backingSet.iterator(), elem -> new AbstractMap.SimpleImmutableEntry<Object, Object>(elem, elem));
    }

    @Override
    public boolean add(Map.Entry<E, E> entry) {
        if (IdentityMappingEntrySet.isIdentity(entry)) {
            return this.backingSet.add(entry.getKey());
        }
        return IdentityMappingEntrySet.throwNotIdentityExpection(entry);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)o;
        if (IdentityMappingEntrySet.isIdentity(entry)) {
            return this.backingSet.remove(entry.getKey());
        }
        return IdentityMappingEntrySet.throwNotIdentityExpection(entry);
    }

    @Override
    public void clear() {
        this.backingSet.clear();
    }

    private static boolean isIdentity(Map.Entry<?, ?> entry) {
        return entry.getKey().equals(entry.getValue());
    }

    private static boolean throwNotIdentityExpection(Map.Entry<?, ?> entry) {
        throw new UnsupportedOperationException("Expected identity mapping, but was: " + entry);
    }
}

