/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.reference;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.DataLeq;
import mb.scopegraph.oopsla20.reference.DataWF;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.IncompleteException;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.oopsla20.terms.newPath.ResolutionPath;
import mb.scopegraph.oopsla20.terms.newPath.ScopePath;
import mb.scopegraph.resolution.RExp;
import mb.scopegraph.resolution.RStep;
import mb.scopegraph.resolution.RVar;
import mb.scopegraph.resolution.State;
import mb.scopegraph.resolution.StateMachine;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.task.ICancel;

public class ResolutionInterpreter<S, L, D> {
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    private final DataWF<D> dataWf;
    private final DataLeq<D> dataEquiv;
    private final StateMachine<L> stateMachine;
    private final Predicate2<S, EdgeOrData<L>> isComplete;

    public ResolutionInterpreter(IScopeGraph.Immutable<S, L, D> scopeGraph, DataWF<D> dataWf, DataLeq<D> dataEquiv, StateMachine<L> stateMachine, Predicate2<S, EdgeOrData<L>> isComplete) {
        this.scopeGraph = scopeGraph;
        this.dataWf = dataWf;
        this.dataEquiv = dataEquiv;
        this.stateMachine = stateMachine;
        this.isComplete = isComplete;
    }

    public Env<S, L, D> resolve(S scope, ICancel cancel) throws ResolutionException, InterruptedException {
        return this.resolve(new ScopePath(scope), this.stateMachine.initial(), cancel);
    }

    private Env<S, L, D> resolve(ScopePath<S, L> path, State<L> state, ICancel cancel) throws ResolutionException, InterruptedException {
        cancel.throwIfCancelled();
        Store store = new Store();
        for (RStep step : state.resolutionSteps()) {
            this.evaluateStep(path, step, store, cancel);
        }
        return store.lookup(state.resultVar());
    }

    private void evaluateStep(ScopePath<S, L> path, RStep<L> step, Store<S, L, D> store, ICancel cancel) throws ResolutionException, InterruptedException {
        Env<S, L, D> env = this.evaluateExp(path, step.getExp(), store, cancel);
        store.store(step.getVar(), env);
    }

    private Env<S, L, D> evaluateExp(final ScopePath<S, L> path, RExp<L> exp, final Store<S, L, D> store, final ICancel cancel) throws ResolutionException, InterruptedException {
        final S scope = path.getTarget();
        Env env = (Env)exp.matchInResolution(new RExp.ResolutionCases<L, Env<S, L, D>>(){

            @Override
            public Env<S, L, D> caseResolve() throws ResolutionException, InterruptedException {
                ResolutionInterpreter.this.checkComplete(scope, EdgeOrData.data());
                Optional datum = ResolutionInterpreter.this.scopeGraph.getData(scope);
                if (datum.isPresent() && ResolutionInterpreter.this.dataWf.wf(datum.get())) {
                    return Env.of(path.resolve(datum.get()));
                }
                return Env.empty();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public Env<S, L, D> caseSubEnv(L label, String stateRef) throws ResolutionException, InterruptedException {
                ResolutionInterpreter.access$0(ResolutionInterpreter.this, scope, EdgeOrData.edge(label));
                newState = ResolutionInterpreter.access$3(ResolutionInterpreter.this).state(stateRef);
                targetIterator = ResolutionInterpreter.access$1(ResolutionInterpreter.this).getEdges(scope, label).iterator();
                firstEnv = null;
                while (targetIterator.hasNext()) {
                    target = targetIterator.next();
                    pathOpt = path.step(label, target);
                    if (!pathOpt.isPresent() || (targetEnv = ResolutionInterpreter.access$4(ResolutionInterpreter.this, pathOpt.get(), newState, cancel)).isEmpty()) continue;
                    firstEnv = targetEnv;
                    break;
                }
                if (firstEnv == null) {
                    return Env.empty();
                }
                envBuilder = null;
                while (targetIterator.hasNext()) {
                    target = targetIterator.next();
                    pathOpt = path.step(label, target);
                    if (!pathOpt.isPresent() || (targetEnv = ResolutionInterpreter.access$4(ResolutionInterpreter.this, pathOpt.get(), newState, cancel)).isEmpty()) continue;
                    envBuilder = Env.builder();
                    envBuilder.addAll(firstEnv);
                    envBuilder.addAll(targetEnv);
                    break;
                }
                if (envBuilder != null) ** GOTO lbl28
                return firstEnv;
lbl-1000:
                // 1 sources

                {
                    target = targetIterator.next();
                    pathOpt = path.step(label, target);
                    if (!pathOpt.isPresent() || (targetEnv = ResolutionInterpreter.access$4(ResolutionInterpreter.this, pathOpt.get(), newState, cancel)).isEmpty()) continue;
                    envBuilder.addAll(targetEnv);
lbl28:
                    // 3 sources

                    ** while (targetIterator.hasNext())
                }
lbl29:
                // 1 sources

                return envBuilder.build();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public Env<S, L, D> caseMerge(List<RVar> envs) {
                varIterator = envs.iterator();
                firstEnv = null;
                while (varIterator.hasNext()) {
                    env = store.lookup(varIterator.next());
                    if (env.isEmpty()) continue;
                    firstEnv = env;
                    break;
                }
                if (firstEnv == null) {
                    return Env.empty();
                }
                envBuilder = null;
                while (varIterator.hasNext()) {
                    env = store.lookup(varIterator.next());
                    if (env.isEmpty()) continue;
                    envBuilder = Env.builder();
                    envBuilder.addAll(firstEnv);
                    envBuilder.addAll(env);
                    break;
                }
                if (envBuilder != null) ** GOTO lbl23
                return firstEnv;
lbl-1000:
                // 1 sources

                {
                    env = store.lookup(varIterator.next());
                    if (env.isEmpty()) continue;
                    envBuilder.addAll(env);
lbl23:
                    // 3 sources

                    ** while (varIterator.hasNext())
                }
lbl24:
                // 1 sources

                return envBuilder.build();
            }

            @Override
            public Env<S, L, D> caseShadow(RVar left, RVar right) throws ResolutionException, InterruptedException {
                Env leftEnv = store.lookup(left);
                Env rightEnv = store.lookup(right);
                if (leftEnv.isEmpty()) {
                    return rightEnv;
                }
                if (rightEnv.isEmpty()) {
                    return leftEnv;
                }
                Env.Builder envBuilder = Env.builder();
                envBuilder.addAll(leftEnv);
                for (ResolutionPath path2 : rightEnv) {
                    if (ResolutionInterpreter.this.isShadowed(path2.getDatum(), leftEnv)) continue;
                    envBuilder.add(path2);
                }
                return envBuilder.build();
            }

            @Override
            public Env<S, L, D> caseCExp(RVar envVar, RExp<L> exp) throws ResolutionException, InterruptedException {
                Env env = store.lookup(envVar);
                if (!env.isEmpty()) {
                    return env;
                }
                return (Env)this.match(exp);
            }
        });
        return env;
    }

    private void checkComplete(S scope, EdgeOrData<L> edge) throws IncompleteException {
        if (!this.isComplete.test(scope, edge)) {
            throw new IncompleteException(scope, edge);
        }
    }

    private boolean isShadowed(D datum, Iterable<ResolutionPath<S, L, D>> specifics) throws ResolutionException, InterruptedException {
        for (ResolutionPath<S, L, D> p : specifics) {
            if (!this.dataEquiv.leq(p.getDatum(), datum)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ StateMachine access$3(ResolutionInterpreter resolutionInterpreter) {
        return resolutionInterpreter.stateMachine;
    }

    static /* synthetic */ Env access$4(ResolutionInterpreter resolutionInterpreter, ScopePath scopePath, State state, ICancel iCancel) throws ResolutionException, InterruptedException {
        return resolutionInterpreter.resolve(scopePath, state, iCancel);
    }

    private static class Store<S, L, D> {
        private final HashMap<RVar, Env<S, L, D>> store = new HashMap();

        private Store() {
        }

        public void store(RVar var, Env<S, L, D> value) {
            this.store.put(var, value);
        }

        public Env<S, L, D> lookup(RVar var) {
            Env<S, L, D> value = this.store.get(var);
            if (value == null) {
                throw new IllegalStateException("Variable " + var + " does not exist.");
            }
            return value;
        }
    }
}

