/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.reference;

import java.util.Optional;
import mb.scopegraph.oopsla20.reference.LabelWF;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.regexp.IRegExpMatcher;

public class RegExpLabelWF<L>
implements LabelWF<L> {
    private final IRegExpMatcher<L> re;

    private RegExpLabelWF(IRegExpMatcher<L> re) {
        this.re = re;
    }

    @Override
    public Optional<LabelWF<L>> step(L l) throws ResolutionException, InterruptedException {
        IRegExpMatcher<L> re = this.re.match(l);
        if (re.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RegExpLabelWF<L>(re));
    }

    @Override
    public boolean accepting() throws ResolutionException, InterruptedException {
        return this.re.isAccepting();
    }

    public String toString() {
        return this.re.toString();
    }

    public static <L> RegExpLabelWF<L> of(IRegExpMatcher<L> re) {
        return new RegExpLabelWF<L>(re);
    }
}

