/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20;

import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import mb.scopegraph.oopsla20.IScopeGraph;
import org.metaborg.util.functions.Function1;

public final class ScopeGraphUtil {
    private ScopeGraphUtil() {
    }

    public static <S, L, D> String toString(IScopeGraph<S, L, D> scopeGraph, Function1<D, D> instantiateData) {
        Map<Map.Entry<S, L>, Iterable<S>> sgEdges = scopeGraph.getEdges();
        Map groupedScopes = sgEdges.entrySet().stream().collect(Collectors.groupingBy(t -> ((Map.Entry)t.getKey()).getKey(), Collectors.mapping(t -> new AbstractMap.SimpleImmutableEntry(((Map.Entry)t.getKey()).getValue(), (Iterable)t.getValue()), Collectors.toSet())));
        Sets.SetView scopes = Sets.union(groupedScopes.keySet(), scopeGraph.getData().keySet());
        StringBuilder sb = new StringBuilder();
        for (Object source : scopes) {
            sb.append(source);
            if (scopeGraph.getData(source).isPresent()) {
                sb.append(" : ");
                sb.append(instantiateData.apply(scopeGraph.getData(source).get()));
            }
            if (!groupedScopes.containsKey(source)) {
                sb.append("\n");
                continue;
            }
            sb.append(" {\n");
            for (Map.Entry edges : groupedScopes.get(source)) {
                sb.append("  ");
                sb.append(edges.getKey());
                sb.append(": ");
                int indent = edges.getKey().toString().length() + 6;
                boolean first = true;
                for (Object target : (Iterable)edges.getValue()) {
                    if (first) {
                        sb.append("[ ");
                        first = false;
                    } else {
                        sb.append(",\n");
                        sb.append(String.join((CharSequence)"", Collections.nCopies(indent, " ")));
                    }
                    sb.append(target);
                }
                sb.append("]\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

