/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20;

import io.usethesource.capsule.Set;
import java.util.Map;
import java.util.Optional;

public interface IScopeGraph<S, L, D> {
    public Set<L> getLabels();

    public Map<? extends Map.Entry<S, L>, ? extends Iterable<S>> getEdges();

    public Iterable<S> getEdges(S var1, L var2);

    public Map<S, D> getData();

    public Optional<D> getData(S var1);

    public static interface Immutable<S, L, D>
    extends IScopeGraph<S, L, D> {
        @Override
        public Set.Immutable<L> getLabels();

        public Immutable<S, L, D> addEdge(S var1, L var2, S var3);

        public Immutable<S, L, D> setDatum(S var1, D var2);

        public Immutable<S, L, D> addAll(IScopeGraph<S, L, D> var1);

        public Transient<S, L, D> melt();
    }

    public static interface Transient<S, L, D>
    extends IScopeGraph<S, L, D> {
        @Override
        public Set.Transient<L> getLabels();

        public boolean addEdge(S var1, L var2, S var3);

        public boolean setDatum(S var1, D var2);

        public boolean addAll(IScopeGraph<S, L, D> var1);

        public Immutable<S, L, D> freeze();
    }
}

