/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.ecoop21;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.regexp.IRegExpMatcher;

public class RegExpLabelWf<L>
implements LabelWf<L>,
Serializable {
    private static final long serialVersionUID = 42L;
    private final IRegExpMatcher<L> re;

    public RegExpLabelWf(IRegExpMatcher<L> re) {
        this.re = re;
    }

    @Override
    public Optional<LabelWf<L>> step(L l) {
        IRegExpMatcher<L> re = this.re.match(l);
        if (re.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RegExpLabelWf<L>(re));
    }

    @Override
    public boolean accepting() {
        return this.re.isAccepting();
    }

    public int hashCode() {
        return Objects.hash(this.re);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegExpLabelWf other = (RegExpLabelWf)obj;
        return Objects.equals(this.re, other.re);
    }

    public String toString() {
        return this.re.toString();
    }

    public static <L> RegExpLabelWf<L> of(IRegExpMatcher<L> re) {
        return new RegExpLabelWf<L>(re);
    }
}

