/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import mb.resource.ResourceRuntimeException;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.ResourcePathDefaults;
import mb.resource.util.SeparatorUtil;
import mb.resource.util.UriEncode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class URLPath
extends ResourcePathDefaults<URLPath>
implements ResourcePath {
    private final URI uri;

    public URLPath(URI uri) {
        this.uri = uri;
    }

    public URLPath(URL url) {
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Failed to convert URL '" + url + "' to a URI", e);
        }
    }

    public URLPath(String str) throws URISyntaxException {
        this.uri = UriEncode.encodeToUri(str);
    }

    public URI getURI() {
        return this.uri;
    }

    public URL getURL() throws MalformedURLException {
        return this.uri.toURL();
    }

    @Override
    public String getQualifier() {
        return "url";
    }

    @Override
    public URI getId() {
        return this.uri;
    }

    @Override
    public String getIdAsString() {
        return this.uri.toString();
    }

    @Override
    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    @Override
    public int getSegmentCount() {
        return 0;
    }

    @Override
    public Iterable<String> getSegments() {
        return () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public String next() {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean startsWith(ResourcePath prefix) {
        if (!(prefix instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot check if this path starts with '" + prefix + "', it is not an URLPath");
        }
        return this.startsWith((URLPath)prefix);
    }

    public boolean startsWith(URLPath prefix) {
        if (!Objects.equals(this.uri.getScheme(), prefix.uri.getScheme())) {
            return false;
        }
        @Nullable String path = this.uri.getPath();
        @Nullable String prefixPath = prefix.uri.getPath();
        if (path != null && prefixPath != null) {
            return path.startsWith(prefixPath);
        }
        return path == null && prefixPath == null;
    }

    @Override
    public @Nullable URLPath getParent() {
        return null;
    }

    @Override
    public @Nullable URLPath getRoot() {
        return null;
    }

    @Override
    public @Nullable String getLeaf() {
        return null;
    }

    @Override
    public @Nullable String getLeafFileExtension() {
        return null;
    }

    @Override
    public URLPath getNormalized() {
        return new URLPath(this.uri.normalize());
    }

    @Override
    public String relativize(ResourcePath other) {
        if (!(other instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot relativize against '" + other + "', it is not an URIPath");
        }
        return this.relativize((URLPath)other);
    }

    public String relativize(URLPath other) {
        return this.uri.relativize(other.uri).toString();
    }

    @Override
    public URLPath appendSegment(String segment) {
        return new URLPath(this.uri.resolve(segment));
    }

    @Override
    public URLPath appendSegments(Iterable<String> segments) {
        return new URLPath(this.uri.resolve(SeparatorUtil.joinWithUnixSeparator(segments)));
    }

    @Override
    public URLPath appendSegments(Collection<String> segments) {
        return new URLPath(this.uri.resolve(SeparatorUtil.joinWithUnixSeparator(segments)));
    }

    @Override
    public URLPath appendSegments(List<String> segments) {
        return new URLPath(this.uri.resolve(SeparatorUtil.joinWithUnixSeparator(segments)));
    }

    @Override
    public URLPath appendSegments(String ... segments) {
        return new URLPath(this.uri.resolve(SeparatorUtil.joinWithUnixSeparator(segments)));
    }

    private URI resolve(String other) throws URISyntaxException {
        return new URI(this.uri.toString() + UriEncode.encodeFull(other));
    }

    @Override
    public URLPath appendRelativePath(String relativePath) {
        try {
            URI relativeURI = UriEncode.encodeToUri(relativePath);
            if (relativeURI.isAbsolute()) {
                throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is an absolute URI");
            }
            return new URLPath(this.resolve(relativePath));
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it cannot be parsed into an URI", e);
        }
    }

    @Override
    public URLPath appendOrReplaceWithPath(String other) {
        try {
            URI otherUri = UriEncode.encodeToUri(other);
            if (otherUri.isAbsolute()) {
                return new URLPath(otherUri);
            }
            return new URLPath(this.resolve(other));
        }
        catch (URISyntaxException e) {
            throw new ResourceRuntimeException("Cannot append or replace with '" + other + "', it cannot be parsed into an URI", e);
        }
    }

    @Override
    public URLPath appendRelativePath(ResourcePath relativePath) {
        if (!(relativePath instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is not an URIPath");
        }
        return this.appendRelativePath((URLPath)relativePath);
    }

    public URLPath appendRelativePath(URLPath relativePath) {
        if (relativePath.isAbsolute()) {
            throw new ResourceRuntimeException("Cannot append '" + relativePath + "', it is an absolute URI");
        }
        return new URLPath(this.uri.resolve(relativePath.uri));
    }

    @Override
    public URLPath appendOrReplaceWithPath(ResourcePath other) {
        if (!(other instanceof URLPath)) {
            throw new ResourceRuntimeException("Cannot append or replace with '" + other + "', it is not an URIPath");
        }
        return this.appendOrReplaceWithPath((URLPath)other);
    }

    public URLPath appendOrReplaceWithPath(URLPath other) {
        return new URLPath(this.uri.resolve(other.uri));
    }

    @Override
    public URLPath replaceLeaf(String segment) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected URLPath self() {
        return this;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLPath that = (URLPath)o;
        return this.uri.equals(that.uri);
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

