/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.text;

import java.io.Serializable;
import java.util.UUID;
import mb.resource.DefaultResourceKey;
import mb.resource.HashMapResourceRegistry;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRuntimeException;
import mb.resource.text.TextResource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextResourceRegistry
extends HashMapResourceRegistry {
    public static final String qualifier = "text";

    public TextResourceRegistry() {
        super(qualifier);
    }

    @Override
    public DefaultResourceKey getResourceKey(ResourceKeyString keyStr) {
        if (!keyStr.qualifierMatchesOrMissing(qualifier)) {
            throw new ResourceRuntimeException("Qualifier of '" + keyStr + "' does not match qualifier '" + qualifier + "' of this resource registry");
        }
        return new DefaultResourceKey(qualifier, keyStr.getId());
    }

    @Override
    protected Serializable toId(ResourceKeyString idStr) {
        return idStr.getId();
    }

    public TextResource createResource(String text, @Nullable String id) {
        id = id != null ? id : UUID.randomUUID().toString();
        TextResource resource = new TextResource(text, id);
        this.addResource(resource);
        return resource;
    }

    public TextResource createResource(String text) {
        return this.createResource(text, null);
    }
}

