/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.util.Collection;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.HierarchicalResourceDefaults;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.SegmentsPath;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SegmentsResource<SELF extends SegmentsResource<SELF>>
extends HierarchicalResourceDefaults<SELF>
implements HierarchicalResource {
    protected final SegmentsPath path;

    protected SegmentsResource(SegmentsPath path) {
        this.path = path;
    }

    @Override
    public SegmentsPath getKey() {
        return this.path;
    }

    @Override
    public SegmentsPath getPath() {
        return this.path;
    }

    public @Nullable SELF getParent() {
        @Nullable SegmentsPath parent = this.path.getParent();
        if (parent == null) {
            return null;
        }
        return this.create(parent);
    }

    public @Nullable SELF getRoot() {
        @Nullable SegmentsPath root = this.path.getRoot();
        if (root == null) {
            return null;
        }
        return this.create(root);
    }

    @Override
    public HierarchicalResource getNormalized() {
        return this.create(this.path.getNormalized());
    }

    public SELF appendSegment(String segment) {
        return this.create(this.path.appendSegment(segment));
    }

    @Override
    public SELF appendSegments(Iterable<String> segments) {
        return this.create((SegmentsPath)this.path.appendSegments((Iterable)segments));
    }

    @Override
    public SELF appendSegments(Collection<String> segments) {
        return this.create((SegmentsPath)this.path.appendSegments((Collection)segments));
    }

    @Override
    public SELF appendRelativePath(String relativePath) {
        return this.create(this.path.appendRelativePath(relativePath));
    }

    public SELF appendOrReplaceWithPath(String other) {
        return this.create(this.path.appendOrReplaceWithPath(other));
    }

    @Override
    public SELF appendString(String other) {
        return this.create((SegmentsPath)this.path.appendString(other));
    }

    @Override
    public SELF appendRelativePath(ResourcePath relativePath) {
        return this.create(this.path.appendRelativePath(relativePath));
    }

    @Override
    public SELF replaceLeaf(String segment) {
        return this.create(this.path.replaceLeaf(segment));
    }

    @Override
    protected abstract SELF self();

    protected abstract SELF create(SegmentsPath var1);

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return this.path.toString();
    }
}

