/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import mb.resource.ReadableResource;
import mb.resource.Resource;
import mb.resource.ResourceKey;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRegistry;
import mb.resource.WritableResource;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.ResourcePath;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ResourceService {
    public Resource getResource(ResourceKey var1);

    public ReadableResource getReadableResource(ResourceKey var1);

    public WritableResource getWritableResource(ResourceKey var1);

    public HierarchicalResource getHierarchicalResource(ResourcePath var1);

    public ResourceKey getResourceKey(ResourceKeyString var1);

    public ResourcePath getResourcePath(ResourceKeyString var1);

    public Resource getResource(ResourceKeyString var1);

    public ReadableResource getReadableResource(ResourceKeyString var1);

    public WritableResource getWritableResource(ResourceKeyString var1);

    public HierarchicalResource getHierarchicalResource(ResourceKeyString var1);

    public Resource appendOrReplaceWith(HierarchicalResource var1, String var2);

    public HierarchicalResource appendOrReplaceWithHierarchical(HierarchicalResource var1, String var2);

    public @Nullable File toLocalFile(ResourceKey var1);

    public @Nullable File toLocalFile(Resource var1);

    public ResourceRegistry getDefaultResourceRegistry();

    public @Nullable ResourceRegistry getResourceRegistry(String var1);

    public ResourceService createChild(ResourceRegistry var1, Iterable<ResourceRegistry> var2, Iterable<ResourceService> var3);

    default public ResourceService createChild(ResourceRegistry defaultRegistry, Iterable<ResourceRegistry> registries) {
        return this.createChild(defaultRegistry, registries, Collections.emptyList());
    }

    default public ResourceService createChild(Iterable<ResourceRegistry> registries) {
        return this.createChild(this.getDefaultResourceRegistry(), registries);
    }

    default public ResourceService createChild(ResourceRegistry ... registries) {
        return this.createChild(this.getDefaultResourceRegistry(), Arrays.asList(registries));
    }

    default public ResourceService createChild(Iterable<ResourceRegistry> registries, Iterable<ResourceService> additionalAncestors) {
        return this.createChild(this.getDefaultResourceRegistry(), registries, additionalAncestors);
    }

    default public ResourceService createChild(ResourceService ... additionalAncestors) {
        return this.createChild(Collections.emptyList(), Arrays.asList(additionalAncestors));
    }
}

