/*
 * Decompiled with CFR 0.152.
 */
package mb.renaming.namegraph;

import java.util.Objects;
import mb.renaming.namegraph.NameIndex;
import org.spoofax.interpreter.terms.IStrategoTerm;

public final class ResolutionPair {
    private final NameIndex reference;
    private final NameIndex declaration;

    public ResolutionPair(NameIndex reference, NameIndex declaration) {
        if (reference == null || declaration == null) {
            throw new IllegalArgumentException("Invalid constructor arguments.");
        }
        this.reference = reference;
        this.declaration = declaration;
    }

    public ResolutionPair(IStrategoTerm pair) {
        this.reference = new NameIndex(pair.getSubterm(0));
        this.declaration = new NameIndex(pair.getSubterm(1));
    }

    public ResolutionPair(String path, int refIndex, int decIndex) {
        if (path == null || decIndex < 0 || refIndex < 0) {
            throw new IllegalArgumentException("Invalid constructor arguments.");
        }
        this.reference = new NameIndex(refIndex, path);
        this.declaration = new NameIndex(decIndex, path);
    }

    public NameIndex getReference() {
        return this.reference;
    }

    public NameIndex getDeclaration() {
        return this.declaration;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResolutionPair)) {
            return false;
        }
        ResolutionPair other = (ResolutionPair)obj;
        if (!other.getReference().equals(this.reference)) {
            return false;
        }
        return other.getDeclaration().equals(this.declaration);
    }

    public int hashCode() {
        return Objects.hash(this.reference, this.declaration);
    }

    public String toString() {
        return "ResolutionPair(" + this.reference.toString() + ", " + this.declaration.toString() + ")";
    }
}

