/*
 * Decompiled with CFR 0.152.
 */
package mb.renaming.namegraph;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mb.renaming.namegraph.NameIndex;
import mb.renaming.namegraph.ResolutionPair;
import org.spoofax.interpreter.terms.IStrategoTerm;

public final class NameGraph {
    private final Set<Set<NameIndex>> clusters = new HashSet<Set<NameIndex>>();

    public NameGraph() {
    }

    public NameGraph(List<IStrategoTerm> resolutionRelation) {
        for (IStrategoTerm pair : resolutionRelation) {
            this.addResolutionPair(new ResolutionPair(pair));
        }
    }

    public void addResolutionPair(ResolutionPair pair) {
        Optional<Set<NameIndex>> decCluster = this.find(pair.getDeclaration());
        Optional<Set<NameIndex>> refCluster = this.find(pair.getReference());
        if (!decCluster.isPresent() && !refCluster.isPresent()) {
            HashSet<NameIndex> cluster = new HashSet<NameIndex>();
            cluster.add(pair.getDeclaration());
            cluster.add(pair.getReference());
            this.clusters.add(cluster);
        } else if (decCluster.isPresent() && !refCluster.isPresent()) {
            decCluster.get().add(pair.getReference());
        } else if (!decCluster.isPresent() && refCluster.isPresent()) {
            refCluster.get().add(pair.getDeclaration());
        } else if (decCluster.isPresent() && refCluster.isPresent()) {
            this.union(decCluster.get(), refCluster.get());
        }
    }

    public Optional<Set<NameIndex>> find(NameIndex index) {
        return this.clusters.stream().filter(cluster -> cluster.contains(index)).findFirst();
    }

    public void union(Set<NameIndex> decCluster, Set<NameIndex> refCluster) {
        if (decCluster != refCluster) {
            decCluster.addAll(refCluster);
            this.clusters.remove(refCluster);
        }
    }
}

