/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.serde;

import java.io.InputStream;
import java.nio.ByteBuffer;

class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer buf;

    ByteBufferBackedInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int minLength = Math.min(length, this.buf.remaining());
        this.buf.get(bytes, offset, minLength);
        return minLength;
    }
}

